/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 RC 1        *
*                (c) 2006-2011 INRIA, USTL, UJF, CNRS, MGH                    *
*                                                                             *
* This program is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU General Public License as published by the Free  *
* Software Foundation; either version 2 of the License, or (at your option)   *
* any later version.                                                          *
*                                                                             *
* This program is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for    *
* more details.                                                               *
*                                                                             *
* You should have received a copy of the GNU General Public License along     *
* with this program; if not, write to the Free Software Foundation, Inc., 51  *
* Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.                   *
*******************************************************************************
*                            SOFA :: Applications                             *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
/*
 * ToolTracker.cpp
 *
 *  Created on: 8 sept. 2009
 *      Author: froy
 */

#ifndef SOFAVRPNCLIENT_SerialPortPressureControl_CPP_
#define SOFAVRPNCLIENT_SerialPortPressureControl_CPP_

#include "SerialPortBridgePressureControl.h"
#include <iostream>
#include <fstream>


using namespace sofa::simulation;

using sofa::helper::WriteAccessor;
using sofa::helper::ReadAccessor;

namespace sofa
{

namespace component
{

namespace controller
{


using namespace sofa::defaulttype;

SOFA_DECL_CLASS(SerialPortPressureControl)

int SerialPortPressureControlClass = core::RegisterObject("Serial port bridge that allows the control of SiliconeV0")
.add< SerialPortPressureControl >()
;

long int portNumber2=-1;

SerialPortPressureControl::SerialPortPressureControl()
    : port(initData(&port, "port", "Serial port name"))
    , baudRate(initData(&baudRate, "baudRate", "Transmission speed"))
    , infosServosm(initData(&infosServosm, "Infos moteurs", "Servomotors information"))
    , sentData(initData(&sentData, "sentData", "Data sent by regular solver"))
{
}


SerialPortPressureControl::~SerialPortPressureControl()
{
    // TODO Auto-generated destructor stub
}


void SerialPortPressureControl::init()
{

            int portNumber2;

            WriteAccessor<Data<vector<float> > > infosservosm= infosServosm;
            infosservosm.resize(50);

            WriteAccessor<Data<vector<float> > > infospneuma = infosPneuma;
            infospneuma.resize(50);

            WriteAccessor<Data<vector<float> > > infossmartservo = infosSmartservo;
            infossmartservo.resize(50);


            WriteAccessor<Data<vector<float> > > infoshydrau = infosHydrau;
            infoshydrau.resize(50);


            WriteAccessor<Data<vector<float> > > diametres = Diametres;
            diametres.resize(50);

            WriteAccessor<Data<vector<float> > > angle_max = Angle_max;
            angle_max.resize(50);

            WriteAccessor<Data<vector<float> > > angle_min = Angle_min;
            angle_min.resize(50);

            WriteAccessor<Data<vector<float> > > precision = Precision;
            precision.resize(50);

            WriteAccessor<Data<vector<float> > > pression_min = Pression_min;
            pression_min.resize(50);

            WriteAccessor<Data<vector<float> > > pression_max = Pression_max;
            pression_max.resize(50);

            WriteAccessor<Data<vector<float> > > info_sup2 = Info_sup2;
            info_sup2.resize(50);

            WriteAccessor<Data<vector<float> > > info_sup1 = Info_sup1;
            info_sup1.resize(50);









            struct	timeval	timeout;
            timeout.tv_sec = 1.000000000000000000000001;
            timeout.tv_usec = 0;
            portNumber2= vrpn_open_commport(port.getValue().c_str() , 9600);

            if(portNumber2==-1)
                std::cerr<<"No serial port found"<<std::endl;
             else
            {
                std::cout<<"Serial Port found "<< portNumber2 <<std::endl;

                unsigned char debut[1]={'a'};
                unsigned char buffer[8]={0,0,0,0,0,0,0,0};
                int bytes=8 ;



                vrpn_write_characters(portNumber2,debut,1);

                    int compteur1=0;
                    int compteur2=0;
                    int compteur3=0;
                    int compteur4=0;
                    int compteurdeb=0;
                    int ia=0;
                    int ib=0;
                    int ic=0;
                    int id=0;



                    while (buffer[0] != 'f') {
                        vrpn_read_available_characters(portNumber2,buffer,bytes,&timeout);


                        char * buffer2 = (char *) buffer;

                        if (compteurdeb ==0)
                        {
                            std::cout<<"nom du robot: "<<buffer<<std::endl;
                            compteurdeb++;
                        }


                        if ( (buffer2[0] != 'e') && (buffer2[1] != 'm') && (compteur1==0))
                        {
                        infosservosm[ia]=atof(buffer2);   // Tableau qui contiendra les informations sur le moteur
                        std::cout<<"infos servos"<<infosservosm[ia]<<std::endl;
                        ia++;
                        }
                       if ( (buffer2[0] == 'e') && (buffer2[1] == 'm'))
                       {
                        compteur1=1;
                        ia=0;
                       std::cout<<"champ  "<<compteur1<<std::endl;
                       }


                     // Nous avons reçu toutes les informations concernant les servos moteur
                       if ( (buffer2[0] != 'e') && (buffer2[1] != 'p') && (compteur2==0) && (compteur1==1))
                       {
                         infospneuma[ib]=atof(buffer2);    // Tableau qui contiendra les informations sur le moteur
                         std::cout<<"infos pneuma" << infospneuma[ib]<<std::endl;
                         ib++;
                       }
                        if ( (buffer2[0] == 'e') && (buffer2[1] == 'p') )
                        {
                        compteur2=1;
                        ib=0;
                        std::cout<<"champ pneuma "<< compteur2 <<std::endl;

                        }


                       // Nous avons reçu toutes les informations concernant les actionneurs pneumatiques
                        if ( (buffer2[0] != 'e') && (buffer2[1] != 'h') && (compteur2==1) && (compteur1==1) && (compteur3==0))
                        {
                          infoshydrau[ic]=atof(buffer2);    // Tableau qui contiendra les informations sur le moteur
                          std::cout<<"infos hydrau" <<infoshydrau[ic]<<"buffer"<< buffer2 <<std::endl;
                          ic++;
                        }
                         if ( (buffer2[0] == 'e') && (buffer2[1] == 'h') )
                         {
                         compteur3=1;
                         ic=0;
                         std::cout<<"champ hydrau "<<compteur3 <<std::endl;
                         }


                         // Nous avons reçu toutes les informations concernant les actionneurs hydrauliques
                         if ( (buffer2[0] != 'e') && (buffer2[1] != 's') && (compteur2==1) && (compteur1==1) && (compteur3 ==1) && (compteur4 ==0))
                          {
                           infossmartservo[id]=atof(buffer2);   // Tableau qui contiendra les informations sur le moteur
                           std::cout<<"infos smart servos" <<infossmartservo[id]<< "buffer"<< buffer2 <<std::endl;
                           id++;
                          }
                          if ( (buffer2[0] == 'e') && (buffer2[1] == 's') )
                          {
                          compteur4=1;
                          id=0;
                          std::cout<<"champ servos "<< compteur4 <<std::endl;
                          }

                          vrpn_flush_input_buffer(portNumber2);
                        // Nous avons reçu toutes les informations concernant les actionneurs smart servos

                                            }

                    std::cout<<"champ servos finaux "<< infospneuma[0] <<std::endl;
                    std::cout<<"champ servos finaux "<< infospneuma[1] <<std::endl;
                    std::cout<<"champ servos finaux "<< infospneuma[2] <<std::endl;
                    std::cout<<"champ servos finaux "<< infospneuma[3] <<std::endl;



                    // Nous retransferons les données dans les différents tableaux afin d'etre qu'elles soient traitées

                    int i0=5;
                    int i1=0;
                    while ((infosservosm[i0] != 998) && (infosservosm[1] != 0))
                    {
                        diametres[i1]=infosservosm[i0];
                        std::cout<<"diametres"<<diametres[i1]<<std::endl;
                        i1++;
                        i0++;
                    }
                    i0++;
                    int i2=0;
                    while ((infosservosm[i0] != 997) && (infosservosm[1] != 0))
                    {
                        angle_min[i2]=infosservosm[i0];
                        std::cout<<"angle_min"<<angle_min[i2]<<std::endl;
                        i0++;
                        i2++;
                    }
                    i0++;
                    int i3=0;
                    while ((infosservosm[i0] != 996) && (infosservosm[1] != 0))
                    {
                        angle_max[i3]=infosservosm[i0];
                        std::cout<<"angle_max"<<angle_max[i3]<<std::endl;
                        i0++;
                        i3++;
                    }
                    i0++;
                    int i4=0;
                    while ((infosservosm[i0] != 995) && (infosservosm[1] != 0))
                    {
                        info_sup1[i4]=infosservosm[i0];
                        std::cout<<info_sup1[i4]<<std::endl;
                        i4++;
                        i0++;
                    }
                    int i5=0;


                    int j0=0;
                    while ((infospneuma[j0] != 994) && (infosservosm[2] != 0))
                    {
                        precision[i5]=infospneuma[j0];
                        std::cout<<"precision"<<precision[i5]<<std::endl;
                        j0++;
                        i5++;
                    }
                    j0++;
                    int i6=0;
                    while ((infospneuma[j0] != 993) && (infosservosm[2] != 0))
                    {
                        pression_min[i6]=infospneuma[j0];
                        std::cout<<"pression_min"<<pression_min[i6]<<std::endl;
                        j0++;
                        i6++;
                    }
                    j0++;
                    int i7=0;
                    while ((infospneuma[j0] != 992) && (infosservosm[2] != 0))
                    {
                        pression_max[i7]=infospneuma[j0];
                        std::cout<<"pression_min"<<pression_max[i7]<<std::endl;
                        j0++;
                        i7++;
                    }
                    j0++;
                    int i8=0;
                    while ((infospneuma[j0] != 991) && (infosservosm[2] != 0))
                    {
                        info_sup2[i7]=infospneuma[j0];
                        std::cout<<"info_sup2"<<info_sup2[i8]<<std::endl;
                        j0++;
                        i8++;
                    }
                }

        vrpn_close_commport(portNumber2);
        }



void SerialPortPressureControl::reinit()
{
    if(portNumber2!=-1)
    {
        vrpn_flush_output_buffer(portNumber2);
        vrpn_close_commport(portNumber2);
    }
    init();
}


void SerialPortPressureControl::update()
{

}

void SerialPortPressureControl::onBeginAnimationStep(const double /*dt*/ )
{



   int nombre_actionneurs=0;
    int tabinfomin[100];
    int tabinfomax[100];
   int passage=1;

    ReadAccessor<Data<vector<float> > > infosservosm = infosServosm;
    ReadAccessor<Data<vector<float> > > infospneuma = infosPneuma;
    ReadAccessor<Data<vector<float> > > infossmartservo = infosSmartservo;
    ReadAccessor<Data<vector<float> > > infoshydrau = infosHydrau;
    ReadAccessor<Data<vector<float> > > diametres = Diametres;
    ReadAccessor<Data<vector<float> > > angle_max = Angle_max;
    ReadAccessor<Data<vector<float> > > angle_min = Angle_min;
    ReadAccessor<Data<vector<float> > > precision = Precision;
    ReadAccessor<Data<vector<float> > > pression_min= Pression_min;
    ReadAccessor<Data<vector<float> > > pression_max = Pression_max;
    ReadAccessor<Data<vector<float> > > info_sup2= Info_sup2;
    ReadAccessor<Data<vector<float> > > info_sup1= Info_sup1;





    while (passage !=3)
       {
       if ((passage ==1) && (infosservosm[1] == 0))
        passage=passage+1;
       if ((passage ==2) && (infosservosm[2] ==0))
        passage=passage+1;



       if (infosservosm[1] != 0 && (passage == 1))
       {
           nombre_actionneurs=infosservosm[1];
       }

       if (infosservosm[2] != 0 && (passage == 2))
       {
           nombre_actionneurs=infosservosm[2];
       }


       unsigned char packet[nombre_actionneurs+1];
       WriteAccessor<Data<vector<double> > > infos_a_p= Infos_a_p;
       infos_a_p.resize(nombre_actionneurs);

       WriteAccessor<Data<vector<double> > > angle= Angle;
        angle.resize(nombre_actionneurs);


       int i;
       for ( i =0; i<nombre_actionneurs; i++)
       {

       if (passage==1)
       {
           tabinfomin[i]=angle_min[i];
           tabinfomax[i]=angle_max[i];
           infos_a_p[i]=(sentData.getValue()[i]+15)*360.0/(diametres[i]*3.14);
       }

       if (infosservosm[2] != 0 && passage==2)
       {
       tabinfomin[i]=pression_min[i];
       tabinfomax[i]=pression_max[i];
       infos_a_p[i]=sentData.getValue()[i];
       }

       if (((angle_min[i]>angle_max[i]) && passage==1) || ((pression_min[i]>pression_max[i]) && passage==2))
         {

             if (infos_a_p[i]<tabinfomax[i])
                 infos_a_p[i]=tabinfomax[i];

             if (infos_a_p[i]>tabinfomin[i])
                 infos_a_p[i]=tabinfomin[i];
          }

         if (((angle_min[i]<angle_max[i]) && passage==1) || ((pression_min[i]<pression_max[i]) && passage==2))
         {

             if (infos_a_p[i]<tabinfomin[i])
                 infos_a_p[i]=tabinfomin[i];

             if (infos_a_p[i]>tabinfomax[i])
                 infos_a_p[i]=tabinfomax[i];
          }
       }


        WriteAccessor<Data<vector<int> > > smoteur= sMoteur;
        smoteur.resize(nombre_actionneurs);

       for ( i=0; i<nombre_actionneurs; i++)
       {
       if ((angle_min[i]>angle_max[i]) && (passage==1))
           smoteur[i] = angle_min[i] - (int) floor(1.0*infos_a_p[i]);

       if ((angle_min[i]< angle_max[i] && (passage==1)) || (infosservosm[2] != 0 && (passage==2)))
           smoteur[i] = (int) floor(1.0*infos_a_p[i]);
       }


       if (passage==1)
       packet[0]=(unsigned char)'b';
       if (passage==2)
       packet[0]=(unsigned char)'c';

       for ( i=0; i<(nombre_actionneurs+1); i++)
       {
           packet[i+1]=(unsigned char)smoteur[i];

       }
         static int portNumber2= vrpn_open_commport(port.getValue().c_str() , 9600);
       if ((infosservosm[1] != 0 && passage==1) || (infosservosm[2] != 0 && passage==2) )
   {   // pour eviter d'envoyé des données quelconques lorsqu'on a 1 seul type d'actionneur
       vrpn_write_characters(portNumber2,packet,nombre_actionneurs);

       std::cout<<"resultat pneuma"<<packet<<std::endl;

   }
    if (passage !=3)
    passage=passage+1;
   }



   }

}


}       //namespace controller

}       //namespace component

      //namespace sofa

#endif //SOFAVRPNCLIENT_SerialPortPressureControl_CPP_
