/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 RC 1        *
*                (c) 2006-2011 INRIA, USTL, UJF, CNRS, MGH                    *
*                                                                             *
* This program is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU General Public License as published by the Free  *
* Software Foundation; either version 2 of the License, or (at your option)   *
* any later version.                                                          *
*                                                                             *
* This program is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for    *
* more details.                                                               *
*                                                                             *
* You should have received a copy of the GNU General Public License along     *
* with this program; if not, write to the Free Software Foundation, Inc., 51  *
* Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.                   *
*******************************************************************************
*                            SOFA :: Applications                             *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
/*
 * ToolTracker.h
 *
 *  Created on: 8 sept. 2009
 *      Author: froy
 */

#ifndef SOFAVRPNCLIENT_SERIALPORT_H_
#define SOFAVRPNCLIENT_SERIALPORT_H_

#include <sofa/core/ObjectFactory.h>
#include <SofaUserInteraction/Controller.h>
#include <sofa/core/objectmodel/Context.h>
#include <sofa/core/objectmodel/BaseObjectDescription.h>

#ifdef WIN32
    #include <vrpn/vrpn_Configure.h>
    #include <vrpn/vrpn_Serial.h>
#else
    #include <vrpn_Configure.h>
    #include <vrpn_Serial.h>
#endif

namespace sofa
{

namespace component
{

namespace controller
{

using namespace sofa::defaulttype;

class SerialPortPressureControl : public Controller
{
public:
    SOFA_CLASS(SerialPortPressureControl, Controller);

    //config
    sofa::Data<std::string> port;
    sofa::Data<int> baudRate, Passage;
    sofa::Data<vector<float> > infosServosm ,infosPneuma,infosHydrau,infosSmartservo,Diametres,Angle_max,Angle_min,Info_sup1,Precision,Pression_min,Pression_max,Info_sup2;
    sofa::Data<vector<double> > Infos_a_p, Angle;
    sofa::Data<vector<int> > sMoteur;


    //output
    sofa::Data<Vec3u> sentData;
    sofa::Data<Vec6d> qpdata;
    sofa::Data<bool> qpactivated;

    //input


    SerialPortPressureControl();
    virtual ~SerialPortPressureControl();

    void init();
    void reinit();
    virtual void update();
    void onBeginAnimationStep(const double dt);

private:

};  //class SerialPort2


}   //namespace controller

}   //namespace component

}   //namespace sofa

#endif /* SOFAVRPNCLIENT_SerialPort2_H_ */

