#include <Wt/WApplication.h>
#include "bandeau/bandeau.h"
#include "./corps/interface.h"
#include "rec/robotino/api2/all.h"

using namespace Wt;



std::string hostname = "127.0.0.1";

rec::robotino::api2::Com com;
rec::robotino::api2::OmniDrive omniDrive;
rec::robotino::api2::Bumper bumper;
rec::robotino::api2::DistanceSensorArray distSensor;
rec::robotino::api2::Odometry odometry;
rec::robotino::api2::Gyroscope gyro;
rec::robotino::api2::MotorArray motor;
rec::robotino::api2::AnalogInputArray analog;
rec::robotino::api2::DigitalInputArray digital;
rec::robotino::api2::DigitalOutputArray digitalOut;
rec::robotino::api2::Charger charger;
rec::robotino::api2::LaserRangeFinder laser;
char ip[20];
char ProgEnCours[100]="Aucun prog en cours";


void init( const std::string& hostname )
{
	// Initialize the actors

	// Connect
	std::cout << "Connecting...";
	com.setAddress( hostname.c_str() );

	com.connectToServer( true );

	if( false == com.isConnected() )
	{
		std::cout << std::endl << "Could not connect to " << com.address() << std::endl;
		exit( 1 );
	}
	else
	{
		std::cout << "success" << std::endl;
	}
}



std::unique_ptr<WApplication> createApplication(const WEnvironment& env)
{
  

  init(hostname);
  std::unique_ptr<WApplication> appl= cpp14::make_unique<WApplication>(env);
  appl->useStyleSheet("main.css");
  auto band = appl->root()->addWidget(cpp14::make_unique<bandeau>());
  band->setStyleClass("bandeau");
  auto corps= appl->root()->addWidget(cpp14::make_unique<interface>(env));
  corps->setStyleClass("corps");
  appl->setTitle("Robotino GUI");
  return appl;

}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
