#include <Wt/WApplication.h>
#include <Wt/WBreak.h>
#include <Wt/WContainerWidget.h>
#include <Wt/WLineEdit.h>
#include <Wt/WPushButton.h>
#include <Wt/WText.h>
#include <Wt/WTimer.h>
#include <Wt/WCheckBox.h>
#include <Wt/WComboBox.h>
#include <Wt/WStringListModel.h>
#include <Wt/WGridLayout.h>
#include <Wt/WSelectionBox.h>
#include <Wt/WFileResource.h>
#include <string.h>

using namespace Wt;

class interface : public WContainerWidget
{
public:
  interface(const WEnvironment& env);
  void menuPrincipal(Wt::WContainerWidget *parent);
  void handlePathChange();
  void etatBumper(Wt::WContainerWidget *parent);
  void etatCapteursDistance(Wt::WContainerWidget *parent);
  void etatOdometrie(Wt::WContainerWidget *parent);
  void etatGyro(Wt::WContainerWidget *parent);
  void etatMotor(Wt::WContainerWidget *parent);
  void capteurs(Wt::WContainerWidget *parent); 
  void etatAnalog(Wt::WContainerWidget *parent);
  void etatDigital(Wt::WContainerWidget *parent);
  void etatDigitalOutput(Wt::WContainerWidget *parent);
  void etatLaser(Wt::WContainerWidget *parent);
  void etatCamera(Wt::WContainerWidget *parent);
  void configWait(Wt::WContainerWidget *parent);
  void config(Wt::WContainerWidget *parent);
  void connect(Wt::WContainerWidget *parent);
  void mdp(Wt::WContainerWidget *parent);
  void choixDemo(Wt::WContainerWidget *parent);
private:
  Wt::WContainerWidget* corps;
};

WText* ajoutText(WContainerWidget *container,const char* text,const char* classeCSS, int centered);
void ajoutBreak(WContainerWidget *container);

WPushButton* ajoutBouton(WContainerWidget *container,const char* text, const char* id,const char* classeCSS, const char* path);

WTimer* addStartTimer(WContainerWidget *container, int time_ms);

void ajoutImage(WContainerWidget *container,const char* name,const char* classeCSS);

WContainerWidget* ajoutContainer(Wt::WContainerWidget *parent,const char* classeCSS);
