#include "interface.h"
#include "rec/robotino/api2/all.h"

extern rec::robotino::api2::Com com;
extern rec::robotino::api2::OmniDrive omniDrive;
extern rec::robotino::api2::Bumper bumper;
extern rec::robotino::api2::DistanceSensorArray distSensor;
extern rec::robotino::api2::Odometry odometry;
extern rec::robotino::api2::Gyroscope gyro;
extern rec::robotino::api2::MotorArray motor;
extern rec::robotino::api2::AnalogInputArray analog;
extern rec::robotino::api2::DigitalInputArray digital;
extern rec::robotino::api2::DigitalOutputArray digitalOut;
extern rec::robotino::api2::LaserRangeFinder laser;
extern std::string hostname;
extern char ip[20];
extern char ProgEnCours[100];
std::string wifichoisi;

int TabDigitalInput[8]={0};

/*****************************************************************/
/*     Fonctions utiles pour la construction de l'interface      */
/*****************************************************************/

WText* ajoutText(WContainerWidget *container,const char* text,const char* classeCSS, int centered)
{
  auto texte = container->addWidget(std::make_unique<Wt::WText>(text));
  if (centered==1)
    texte->setTextAlignment(Wt::AlignmentFlag::Center);
  texte->setInline(0);
  if(classeCSS !=NULL)
    texte->setStyleClass(classeCSS);
  return texte;
}

void ajoutBreak(WContainerWidget *container)
{
  container->addWidget(Wt::cpp14::make_unique<Wt::WBreak>());
}


WContainerWidget* ajoutContainer(Wt::WContainerWidget *parent,const char* classeCSS)
{
  WContainerWidget* container=parent->addWidget(std::make_unique<Wt::WContainerWidget>());
  if(classeCSS!=NULL)
    container->setStyleClass(classeCSS);
  return container;
}

WPushButton* ajoutBouton(WContainerWidget *container,const char* text, const char* id, const char* classeCSS, const char* path){
  WPushButton *btn = container->addWidget(std::make_unique<Wt::WPushButton>(text));  
  btn->setTextFormat(TextFormat::XHTML);
  if (id!=NULL)
    btn->setId(id);
  if(classeCSS!=NULL)
    btn->setStyleClass(classeCSS);
  btn->setLink(WLink(Wt::LinkType::InternalPath,path));
  return btn;
}

WTimer* addStartTimer(WContainerWidget *container, int time_ms){
  WTimer *timer=container->addChild(std::make_unique<Wt::WTimer>());
  timer->setInterval(std::chrono::milliseconds(time_ms));
  timer->start();
  return timer;
}


void ajoutImage(WContainerWidget *container,const char* name,const char* classeCSS){
  auto image =Wt::cpp14::make_unique<Wt::WImage>(Wt::WLink(name));
  if(classeCSS!=NULL)
    image->setStyleClass(classeCSS);
  container->addWidget(std::move(image));
}


/*****************************************************************/
/*  Construction des differents menus du corps de l'interface    */
/*****************************************************************/

interface::interface(const WEnvironment& env) : WContainerWidget()
{                           
  corps= addWidget(std::make_unique<Wt::WContainerWidget>());
  menuPrincipal(corps);  
}

//menu Principal : 3 boutons permettant de choisir la configuration, les capteurs ou les démos
void interface::menuPrincipal(Wt::WContainerWidget *parent)
{
  auto container2=ajoutContainer(parent,"container2");

  WPushButton *buttonReseau = ajoutBouton(container2,"<br/><br/>Configuration<br/> Reseau","buttonReseau",NULL,"/config/wait");
  buttonReseau->setIcon("internet.png");

  WPushButton *buttonCapteur = ajoutBouton(container2,"<br/><br/>Visualisation <br/>Etat des capteurs","buttonCapteur",NULL,"/capteurs");      
  buttonCapteur->setIcon("capteur.png");
  
  WPushButton *buttonDemo = ajoutBouton(container2,"<br/>Lancement <br/>Programmes <br/>de demonstration","buttonDemo",NULL,"/demo");
  buttonDemo->setIcon("demo.png");

  WApplication *app = WApplication::instance();
  app->internalPathChanged().connect(this, &interface::handlePathChange); //indication de la fonction à appeler lors changement de path

}


void interface::handlePathChange()
{
    WApplication *app = WApplication::instance();
    app->useStyleSheet("main.css");
    corps->clear();
    if (app->internalPath() == "/capteurs")
	    capteurs(corps);
    else if (app->internalPath()=="/config/connect")
	    connect(corps);
    else if (app->internalPath() == "/capteurs/bumper")
      etatBumper(corps);
    else if (app->internalPath() == "/capteurs/capteursDistance")
      etatCapteursDistance(corps);  
    else if (app->internalPath() == "/capteurs/odometrie")
      etatOdometrie(corps);
    else if (app->internalPath() == "/capteurs/gyroscope")
      etatGyro(corps);
    else if (app->internalPath() == "/capteurs/motor")
      etatMotor(corps);
    else if (app->internalPath() == "/capteurs/analog")
      etatAnalog(corps);
    else if (app->internalPath() == "/capteurs/digital")
      etatDigital(corps);
    else if (app->internalPath() == "/capteurs/digitalOutput")
      etatDigitalOutput(corps);
    else if (app->internalPath() == "/capteurs/laser")
      etatLaser(corps);
    else if (app->internalPath() == "/capteurs/camera")
      etatCamera(corps);
    else if (app->internalPath() == "/config")
	    config(corps);
    else if (app->internalPath() == "/config/wait")
      configWait(corps);
    else if (app->internalPath()== "/config/mdp")
      mdp(corps);
    else if(app->internalPath() == "/demo")
      choixDemo(corps);
    else if (app->internalPath()=="/")
      menuPrincipal(corps); 
}

void interface::configWait(Wt::WContainerWidget *parent)
{
  auto containerConfigWait=ajoutContainer(parent,"container1");
  ajoutBreak(containerConfigWait);
  ajoutText(containerConfigWait,"Detection des réseaux Wifi en cours...","NomCapteur",1);
  auto mytimer=addStartTimer(containerConfigWait,10);
    mytimer->timeout().connect([=] {
    WApplication *app=WApplication::instance();
    app->setInternalPath("/config",1);
  });
}


void interface::config(Wt::WContainerWidget *parent)
{
  auto containerConfig=ajoutContainer(parent,"container1");
  ajoutBreak(containerConfig);
  ajoutText(containerConfig,"Choisir un réseau Wifi","NomCapteur",1);
  ajoutBreak(containerConfig);
  
  FILE *fp=popen("super listeWifi","r");
  char nomWifi[100];
  auto selection=containerConfig->addWidget(Wt::cpp14::make_unique<Wt::WSelectionBox>());
  selection->setId("menuDeroulant");
  auto model = std::make_shared<Wt::WStringListModel>();
  while(fgets(nomWifi,100,fp))
	  if(nomWifi!="\x00")
	  model->addString(nomWifi);
  selection->setModel(model);
  pclose(fp);
  auto BoutonValider=ajoutBouton(containerConfig, "Choisir ce réseau Wifi",NULL,"buttonEntier","/config/mdp");
  wifichoisi=selection->currentText().toUTF8().c_str();
  //suppression du caractere de fin de ligne
  wifichoisi=wifichoisi.substr(0,wifichoisi.length()-1);

  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/");
}

void interface::mdp(Wt::WContainerWidget *parent)
{
  auto containerConfigMDP=ajoutContainer(parent,"container1");
  ajoutBreak(containerConfigMDP);
  ajoutText(containerConfigMDP,"Entrez le mot de passe :","NomCapteur",1);
  ajoutBreak(containerConfigMDP);
  
  auto mdp=containerConfigMDP->addWidget(Wt::cpp14::make_unique<Wt::WLineEdit>());
  mdp->setEchoMode(Wt::EchoMode::Password);
  mdp->setId("MDPEdit");
  
  auto BoutonValiderMDP=ajoutBouton(containerConfigMDP,"Se connecter",NULL,"buttonEntier","/config/connect");
  BoutonValiderMDP->clicked().connect([=]{
    std::string mdpchoisi=mdp->text().toUTF8().c_str();
    //suppression du caractere de fin de ligne
    mdpchoisi=mdpchoisi.substr(0,mdpchoisi.length());
    std::string commande="wpa_passphrase "+ wifichoisi +" " +mdpchoisi+"> ~/wpa.conf";

    system(commande.c_str());
    system("super connexionWifi");
    FILE *fp=popen("./scripts/getIP.sh","r");
    fgets(ip,20,fp);
    pclose(fp);
    });
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/");

}

void interface::connect(Wt::WContainerWidget *parent)
{
  auto containerConnect=ajoutContainer(parent,"container1");
  ajoutBreak(containerConnect);
  ajoutText(containerConnect,"Connecté","NomCapteur",1);
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/");

}


void interface::capteurs(Wt::WContainerWidget *parent)
{
  auto containerCapteurs=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteurs);
  ajoutText(containerCapteurs,"Selectionner capteur : ","NomCapteur",1);
  ajoutBreak(containerCapteurs);

  auto containerCapteurbis=containerCapteurs->addWidget(std::make_unique<Wt::WContainerWidget>());
  auto layout = std::make_unique<Wt::WGridLayout>();

  auto btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Bumper"),0,0);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/bumper"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Capteurs de distance"),1,0);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/capteursDistance"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Odometrie"),2,0);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/odometrie"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Moteurs"),3,0);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/motor"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Gyroscope"),4,0);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/gyroscope"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Entrees analogiques"),0,1);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/analog"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Entrees digitales"),1,1);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/digital"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("sorties digitales"),2,1);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/digitalOutput"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Laser"),3,1);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/laser"));
  btn->setInline(0);

  btn = layout->addWidget(std::make_unique<Wt::WPushButton>("Camera"),4,1);
  btn->setStyleClass("btnCapteurs");
  btn->setLink(WLink(Wt::LinkType::InternalPath,"/capteurs/camera"));
  btn->setInline(0);

  containerCapteurbis->setLayout(std::move(layout));

  auto containerRetour= ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerCapteurs,"Retour",NULL,"buttonRetour","/");

}

void interface::etatBumper(Wt::WContainerWidget *parent)
{
  auto containerCapteur1=ajoutContainer(parent,"container1");
  auto mytimer=addStartTimer(containerCapteur1,10);
  ajoutBreak(containerCapteur1);
  ajoutText(containerCapteur1,"Bumper : ","NomCapteur",1);
  ajoutBreak(containerCapteur1);
  WText *state=ajoutText(containerCapteur1,NULL,"infoCapteur",1);
  mytimer->timeout().connect([=] {
    if(bumper.value()==true)
    {
      state->setText("True");
      containerCapteur1->setStyleClass("containerRed");
    }
    else if (bumper.value()==false)
    {
      state->setText("False");
      containerCapteur1->setStyleClass("containerGreen");
    }
  });
  ajoutBreak(containerCapteur1);

  auto container2=ajoutContainer(parent,"containerRetour");
  ajoutBouton(container2,"Retour",NULL,"buttonRetour","/capteurs");
  
}

void interface::etatCapteursDistance(Wt::WContainerWidget *parent)
{
  auto containerCapteur2=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur2);
  ajoutText(containerCapteur2,"Capteurs de distance : ","NomCapteur",1);
  ajoutBreak(containerCapteur2);

  auto containerCapteur2bis=containerCapteur2->addWidget(std::make_unique<Wt::WContainerWidget>());
  auto layout = std::make_unique<Wt::WGridLayout>();
  
  std::vector<float> vec(distSensor.numDistanceSensors());  //vecteur qui contient les valeurs des capteurs
  std::vector<Wt::WText*> statedist(vec.size());            //vecteurs de WText
  int column,rowC1=0,rowC2=0,row;
  for(int i=0;i<vec.size();i++)
  {
    if(i<=vec.size()/2)
      {
        column=0; row=rowC1++;
      }
    else
    {
      column=1; row=rowC2++;
    }
    statedist[i]=layout->addWidget(std::make_unique<Wt::WText>(""),row,column);
    statedist[i]->setTextAlignment(Wt::AlignmentFlag::Center);
    statedist[i]->setStyleClass("infoCapteur");
  }
  containerCapteur2bis->setLayout(std::move(layout));

  auto mytimer=addStartTimer(containerCapteur2,10);
  mytimer->timeout().connect([=] {
    distSensor.distances((float*)&vec[0]);
    for(int i=0;i<vec.size();i++)
      statedist[i]->setText("Capteur "+std::to_string(i)+" : "+std::to_string(vec[i])+" m");
  });

  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
  
}

void interface::etatOdometrie(Wt::WContainerWidget *parent)
{
  auto containerCapteur3=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur3);
  ajoutText(containerCapteur3,"Odometrie : ","NomCapteur",1);
  ajoutBreak(containerCapteur3);

  WText *stateX = ajoutText(containerCapteur3,NULL,"infoCapteur",1);
  ajoutBreak(containerCapteur3);
  WText *stateY = ajoutText(containerCapteur3,NULL,"infoCapteur",1);
  ajoutBreak(containerCapteur3);
  WText *statePhi = ajoutText(containerCapteur3,NULL,"infoCapteur",1);
  ajoutBreak(containerCapteur3);

  auto mytimer=addStartTimer(containerCapteur3,10);
  mytimer->timeout().connect([=] {
    unsigned int sequence =0;
    double x,y,phi;
    odometry.readings(&x,&y,&phi,&sequence);
    stateX->setText("x = "+std::to_string(x)+" m");
    stateY->setText("y = "+std::to_string(y)+" m");
    statePhi->setText("phi = "+std::to_string(phi)+" °");
  });

  ajoutImage(containerCapteur3,"odometrie.png","imageCapteur");
  
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");

}



void interface::etatGyro(Wt::WContainerWidget *parent)
{
  auto containerCapteur4=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur4);
  ajoutText(containerCapteur4,"Gyroscope : ","NomCapteur",1);
  ajoutBreak(containerCapteur4);

  auto mytimer=addStartTimer(containerCapteur4,10);

  WText *state=ajoutText(containerCapteur4,NULL,"infoCapteur",1);
  mytimer->timeout().connect([=] {
    state->setText(std::to_string(gyro.angle())+" °");
    });
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
}


void interface::etatMotor(Wt::WContainerWidget *parent)
{
  auto containerCapteur5=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur5);
  ajoutText(containerCapteur5,"Moteurs : ","NomCapteur",1);
  ajoutBreak(containerCapteur5);
  auto mytimer=addStartTimer(containerCapteur5,10);

  std::vector<Wt::WText*> stateMotor(motor.numMotors());
  for(int i=0;i<motor.numMotors();i++)
  {
    stateMotor[i]=ajoutText(containerCapteur5,NULL,"infoCapteur",1);
    ajoutBreak(containerCapteur5);
  }

  mytimer->timeout().connect([=] {
    std::vector<float> vec(motor.numMotors() );
    motor.actualVelocities( &vec[0] );
    for(int i=0;i<vec.size();i++)
    {
      stateMotor[i]->setText("Moteur n°"+std::to_string(i)+" : "+std::to_string(vec[i])+" tours/min");
    }
  });
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");

}

void interface::etatAnalog(Wt::WContainerWidget *parent)
{
  auto containerCapteur6=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur6);
  ajoutText(containerCapteur6,"Entrées Analogiques : ","NomCapteur",1);
  ajoutBreak(containerCapteur6);

  auto containerCapteur6bis=containerCapteur6->addWidget(std::make_unique<Wt::WContainerWidget>());
  auto layout = std::make_unique<Wt::WGridLayout>();
  
  std::vector<float> vec(analog.numAnalogInputs());          //vecteur qui contient les valeurs des capteurs
  std::vector<Wt::WText*> stateAnalog(analog.numAnalogInputs());    //vecteurs de WText
  int column,rowC1=0,rowC2=0,row;
  for(int i=0;i<vec.size();i++)
  {
    if(i<vec.size()/2)
      {
        column=0; row=rowC1++;
      }
    else
    {
      column=1; row=rowC2++;
    }
    stateAnalog[i]=layout->addWidget(std::make_unique<Wt::WText>(""),row,column);
    stateAnalog[i]->setTextAlignment(Wt::AlignmentFlag::Center);
    stateAnalog[i]->setStyleClass("infoCapteur");
  }
  containerCapteur6bis->setLayout(std::move(layout));

  auto mytimer=addStartTimer(containerCapteur6,10);
  mytimer->timeout().connect([=] {
    analog.values((float*)&vec[0]);
    for(int i=0;i<vec.size();i++)
      stateAnalog[i]->setText("Entree "+std::to_string(i)+" : "+std::to_string(vec[i]));
  });

  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
  
}

void interface::etatDigital(Wt::WContainerWidget *parent)
{
  auto containerCapteur7=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur7);
  ajoutText(containerCapteur7,"Entrees digitales:","NomCapteur",1);
  ajoutBreak(containerCapteur7);

  auto containerCapteur7bis=containerCapteur7->addWidget(std::make_unique<Wt::WContainerWidget>());
  auto layout = std::make_unique<Wt::WGridLayout>();
  
  std::vector<int> vec(digital.numDigitalInputs());                    //vecteur qui contient les valeurs des capteurs
  std::vector<Wt::WText*> stateDigital(digital.numDigitalInputs());    //vecteurs de WText
  int column,rowC1=0,rowC2=0,row;
  for(int i=0;i<vec.size();i++)
  {
    if(i<vec.size()/2)
      {
        column=0; row=rowC1++;
      }
    else
    {
      column=1; row=rowC2++;
    }
    stateDigital[i]=layout->addWidget(std::make_unique<Wt::WText>(""),row,column);
    stateDigital[i]->setTextAlignment(Wt::AlignmentFlag::Center);
    stateDigital[i]->setStyleClass("infoCapteur");
  }
  containerCapteur7bis->setLayout(std::move(layout));

  auto mytimer=addStartTimer(containerCapteur7,10);
  mytimer->timeout().connect([=] {
    digital.values((int*)&vec[0]);
    for(int i=0;i<vec.size();i++)
      stateDigital[i]->setText("Entree "+std::to_string(i)+" : "+std::to_string(vec[i]));
  });

  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
  
}

void interface::etatDigitalOutput(Wt::WContainerWidget *parent)
{
  auto containerCapteur8=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur8);
  ajoutText(containerCapteur8,"Sorties digitales :","NomCapteur",1);
  ajoutBreak(containerCapteur8);
  std::vector<Wt::WPushButton*> stateDigital(digitalOut.numDigitalOutputs());

  auto containerCapteur8bis=containerCapteur8->addWidget(std::make_unique<Wt::WContainerWidget>());
  auto layout = std::make_unique<Wt::WGridLayout>(); 

  int row=0,columnR1=0, columnR2=0,column=0; 

  for(int i=0;i<digitalOut.numDigitalOutputs();i++)
  {
    if(i<digitalOut.numDigitalOutputs()/2)
        {
          row=0;
          column=columnR1++;
        }
    else
        {
          row=2;
          column=columnR2++;
        }
    auto text=layout->addWidget(std::make_unique<Wt::WText>("<br/>Sortie n°"+std::to_string(i)),row,column);
    text->setTextAlignment(Wt::AlignmentFlag::Center);
    text->setStyleClass("infoCapteur");
    row++;
    stateDigital[i]=layout->addWidget(std::make_unique<Wt::WPushButton>(),row,column);
    stateDigital[i]->setInline(0);
    if(TabDigitalInput[i]==0) 
        {
          stateDigital[i]->setStyleClass("btnRed");
          stateDigital[i]->setText("Activer");

        }
        else 
        {
          stateDigital[i]->setStyleClass("btnGreen");
          stateDigital[i]->setText("Desactiver");
        }

    stateDigital[i]->clicked().connect([=]{
        if(TabDigitalInput[i]==0) //on active la sortie
        {
          TabDigitalInput[i]=1;
          stateDigital[i]->setStyleClass("btnGreen");
          stateDigital[i]->setText("Desactiver");

        }
        else //on désactive la sortie
        {
          TabDigitalInput[i]=0;
          stateDigital[i]->setStyleClass("btnRed");
          stateDigital[i]->setText("Activer");
        }
        digitalOut.setValues(TabDigitalInput,digitalOut.numDigitalOutputs());
    });
  
  }	
  containerCapteur8bis->setLayout(std::move(layout));
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
}

void interface::etatLaser(Wt::WContainerWidget *parent)
{
  auto containerCapteur9=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerCapteur9);
  ajoutText(containerCapteur9,"Laser","NomCapteur",1);
  ajoutBreak(containerCapteur9);

  WText* state= ajoutText(containerCapteur9,NULL,"infoCapteur",1);

  auto mytimer=addStartTimer(containerCapteur9,10);
  mytimer->timeout().connect([=]{
    rec::robotino::api2::LaserRangeFinderReadings values=laser.readings();
    state->setText("Angle min ="+std::to_string(values.angle_max)+"°"
    +"<br/>Angle max="+std::to_string(values.angle_max)+"°"
    +"<br/>Angle increment"+std::to_string(values.angle_increment)+"°"
    +"<br/>Time increment="+std::to_string(values.time_increment)+"s"
    +"<br/>Scan time="+std::to_string(values.scan_time)+"s"
    +"<br/>Range min="+std::to_string(values.range_min)
    +"<br/>Range max="+std::to_string(values.range_max)
    );
  });
  
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
}

void interface::etatCamera(Wt::WContainerWidget *parent)
{
  auto containerCapteur10=ajoutContainer(parent,"container10");
  
  ajoutBreak(containerCapteur10);
  ajoutText(containerCapteur10,"Camera","NomCapteur",1);
  ajoutBreak(containerCapteur10);


  auto imageFile = std::make_shared<Wt::WFileResource>("image/jpg", "./ressources/camera.jpg");
  imageFile->suggestFileName("camera.jpg");
  auto image = std::make_unique<Wt::WImage>(Wt::WLink(imageFile));
  image->setId("camera");
  containerCapteur10->addWidget(std::move(image));
  system("super camera & ");
  auto mytimer=addStartTimer(containerCapteur10,100);
  mytimer->timeout().connect([=] {
  
		  imageFile->setChanged();
		  }
  );
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  auto BoutonRetour=ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/capteurs");
  BoutonRetour->clicked().connect([=] {
		  system("super killcamera");
		  });
}



void interface::choixDemo(Wt::WContainerWidget *parent)
{
  auto containerDemo=ajoutContainer(parent,"container1");
  
  ajoutBreak(containerDemo);
  ajoutText(containerDemo,"Choisir un programme de démonstration : ","NomCapteur",1);
  ajoutBreak(containerDemo);
  auto selection =containerDemo->addWidget(Wt::cpp14::make_unique<Wt::WSelectionBox>());
  selection->setId("menuDeroulant");

  auto model = std::make_shared<Wt::WStringListModel>();
  model->addString("Circle");
  model->setData(0, 0, std::string("/usr/local/robotino/examples/bin/example_circle"), Wt::ItemDataRole::User);

  model->addString("Netherlands");
  model->setData(1, 0, std::string("NL"), Wt::ItemDataRole::User);

  selection->setModel(model);
  selection->setCurrentIndex(0);
  ajoutBreak(containerDemo);


  auto BoutonValider= ajoutBouton(containerDemo,"Choisir ce programme",NULL,"buttonEntier","/demo");
  ajoutBreak(containerDemo);
  auto BoutonArretDemo=ajoutBouton(containerDemo,"Arreter le programme en cours",NULL,"buttonEntier","/demo");
  
  BoutonValider->clicked().connect([=]{
      Wt::WString choix = selection->currentText();
      int row = selection->currentIndex();
      Wt::WString commande = Wt::asString(model->data(model->index(row,0), Wt::ItemDataRole::User));
      std::string command_string = commande.toUTF8()+" "+hostname+" &";
      system(command_string.c_str());
      strcpy(ProgEnCours,choix.toUTF8().c_str());


  });

  BoutonArretDemo->clicked().connect([=]{
    Wt::WString countryName = selection->currentText();
    int row = selection->currentIndex();
    Wt::WString commande = Wt::asString(model->data(model->index(row,0), Wt::ItemDataRole::User));
    std::string command_string = "kill -9 $(pidof -x \""+commande.toUTF8()+"\")";
    system(command_string.c_str());
    strcpy(ProgEnCours,"Aucun prog en cours");

    });
  auto containerRetour=ajoutContainer(parent,"containerRetour");
  ajoutBouton(containerRetour,"Retour",NULL,"buttonRetour","/");
}





