#include <Wt/WContainerWidget.h>
#include <Wt/WHBoxLayout.h>
#include <Wt/WText.h>
#include<Wt/WImage.h>
#include<Wt/WTimer.h>
#include "bandeau.h"

#include "rec/robotino/api2/all.h"

extern rec::robotino::api2::Charger charger;
extern std::string hostname;
extern char ip[20];
extern char ProgEnCours[100];

bandeau::bandeau() : WContainerWidget()
 {
 
auto hbox = setLayout(Wt::cpp14::make_unique<Wt::WHBoxLayout>());

std::unique_ptr<Wt::WText> item = Wt::cpp14::make_unique<Wt::WText>();
FILE *fp=popen("./scripts/getIP.sh","r");
fgets(ip,20,fp);
pclose(fp);
item->setText(ip);
item->setStyleClass("infos_bandeau");
auto text_IP=hbox->addWidget(std::move(item));


item = Wt::cpp14::make_unique<Wt::WText>(ProgEnCours);
item->setStyleClass("infos_bandeau");
auto textProg=hbox->addWidget(std::move(item),1);


auto BoutonStop=hbox->addWidget(std::make_unique<Wt::WPushButton>("STOP"),1);
BoutonStop->setId("btnStop");
BoutonStop->setInline(0);

std::unique_ptr<Wt::WImage> image =Wt::cpp14::make_unique<Wt::WImage>(Wt::WLink("wifi1.png"));
image->setAlternateText("WIFI:");
image->setId("WIFI");
auto imageWifi=hbox->addWidget(std::move(image));
char nomWifi[100];
fp=popen("./scripts/getWifi.sh","r");
fgets(nomWifi,100,fp);
pclose(fp);
item = Wt::cpp14::make_unique<Wt::WText>(nomWifi);
item->setStyleClass("infos_bandeau");
auto textWifi=hbox->addWidget(std::move(item));


WTimer* mytimer=hbox->addChild(std::make_unique<Wt::WTimer>());
mytimer->setInterval(std::chrono::milliseconds(10));
mytimer->start();
mytimer->timeout().connect([=] {
	FILE* fp=popen("./scripts/getIP.sh","r");
	fgets(ip,20,fp);
	pclose(fp);
	text_IP->setText(ip);

	textProg->setText(ProgEnCours);
	
	char nomWifi[100];
	fp=popen("./scripts/getWifi.sh","r");
	fgets(nomWifi,100,fp);
	pclose(fp);
	textWifi->setText(nomWifi);

	char quality[3];
	fp=popen("./scripts/QualiteWifi.sh","r");
	fgets(quality,3,fp);
	pclose(fp);
	int qualitynb=atoi(quality);
	if(qualitynb > 54)
		imageWifi->setImageLink(Wt::WLink("wifi4.png"));
	else if (qualitynb>36)
		imageWifi->setImageLink(Wt::WLink("wifi3.png"));
	else if (qualitynb>18)
		imageWifi->setImageLink(Wt::WLink("wifi2.png"));
	else
		imageWifi->setImageLink(Wt::WLink("wifi1.png"));
});

}
