%% Matlab program: InitIMA5A1920P5.m
%Matlab init file for REM IMA5A1920P5
clc; clear

%%Batterie
BAT.U = 9 ;%tension de la pile en V


%%Regulateur 5V

RED.UBAT = 5/9; % regulateur de tension 5V


%%Cellule photovoltaque

PV.I0 = 0.8; %courant de saturation, fluctue avec l'irradiance sur la cellule
PV.VT = 8.2; %tension en court circuit
PV.k = 1.3806e-23; %constante de Boltzmann en J.K-1
PV.q = 1.6022e-19; %charge d'un electrion en C
PV.TC = 18;
PV.T = PV.TC + 273.15; %temprature en Kelvin
%% Panneaux Photovoltaques
tension_pv = linspace(0,PV.VT,PV.VT*10);
courant_pv = ones(PV.VT*10,1);
puissance_pv = ones(1,PV.VT*10);
for n = 1:PV.VT*10
    courant_pv(n,1)=PV.I0*(-exp(-PV.q*(PV.VT-tension_pv(n))/(PV.k*PV.T*60))+1);
    puissance_pv(1,n)=tension_pv(1,n)*courant_pv(n,1);
end
 
plotyy(tension_pv,courant_pv,tension_pv,puissance_pv,'plot')
xlabel('Tension U en V')
legend('Courant I en A','Puissance P en W')

title('Courbe de tension/courant et tension/puissance de la cellule photovoltaque')
%% Bus continu PV
BUS.C = 200e-6;      % Capacit du bus continu (F)
BUS.R_C = 50e3;     % Rsistance de fuite du bus continu (Ohm)

BUS.Tau_C = BUS.C*BUS.R_C;  % Constante de temps du bus continu (sec)
BUS.K_C = BUS.R_C;          % Gain statique du bus continu (Ohm)

%% Filtre PV
FILT.L = 10e-3;     % Inductance du filtre (H)
FILT.R_L = 25e-3;   % Rsistance srie du filtre (Ohm)

FILT.Tau_L = FILT.L/FILT.R_L;   % Constante de temps du filtre (sec)
FILT.K_L = 1/FILT.R_L;          % Gain statique du filtre (S)

%%Moteur courant continu
    % --- MCC Parameters ---
        % --- Description ---
    
    MCC.U = 3;							% Nominal voltage of the armature winding (V)
    MCC.I = 1.04;							% Nominal Current of the armature winding (A)
    MCC.N = 12200;								% Nominal speed (rpm)
    MCC.W = MCC.N*pi/30;					% Nominal speed (rad/s)
    MCC.P = MCC.U*MCC.I;    % Nominal electrical power of the armature winding (W)
    MCC.P_util = 0.4;                          % Nominal useful power (W)
    MCC.tho = 0.003;
    MCC.R=2.2;
    MCC.L=8.54e-2;
 	    % --- Elec1romechanical conversion ---	
     MCC.K  = (MCC.U-MCC.R*MCC.I)/(MCC.W);   
      % Torque Coefficient via the excitation Flux
    
    MCC.tho = 0.0014;
%%Vhicule

VEH.R = 0.0145;%rayon de la roue en m

VEH.M = 0.467; %masse du mobile en kg

VEH.MPLUS = 0; %masse en charge sur le vhicule en kg

VEH.MTOT = VEH.M + VEH.MPLUS; %masse totale du vhicule

VEH.J = 1.2e-3; %inertie du vhicule  dfinir

VEH.f = 0.05; %frottements


%%Reduction 
RED.ARBRE = (12/64)*(12/64); %rapport de rduction li  l'arbre du moteur

RED.VP = 10/16; % rapport de rduction li au systme engrenage/pignon

RED.pertes = 1;



      % --- Environment parameters ---
            % /// Aerodynamic Resistance ///
            % Far = (rho.Cx.A.(V+Vwind))/2
            ENV.g = 9.81;                         % gravity (m/s^2)
            ENV.A = 2;                            % Frontal aera (m^2)
            ENV.Cx = 0.35;                        % Drag coefficient
            ENV.rho = 1.223;                      % Density of the air with 20C under 1013 mbar (kg/m^3)
            ENV.kaero = ENV.rho*ENV.Cx*ENV.A/2;   % Constant for the resistance force to aerodynamics
            ENV.Vwind = 0;                        % Velocity of the wind (m/s)

            % --- Grade Resistance ---
            % Fgr = m.g.sin(alpha)
            % As the grade alpha is often small the relationship is generally writen Fgr = m.g.gradient with sin(alpha) = tan(alpha) = gradient = height / lenght
            ENV.gradient =  0;                              % Gradient of the road (%)
            ENV.kgr = VEH.MTOT*ENV.g*ENV.gradient/100;       % Constant gain for the grade relationship

            % --- Rolling Resistance ---
            % Frr = k1.M.g.cos(alpha)
            % As the grade alpha is often small the relationship is generally writen Frr = k1.m.g because cos(alpha) = sin(alpha)/tan(alpha) = 1            
            ENV.k1_road = 0.017;                  % Constant resistance coefficient of the rolling for the roadway
            ENV.krr = ENV.k1_road*VEH.MTOT*ENV.g;  % Constant gain for the rolling relationship


%% Control parameters
% Maximal Control Structure:
% - all variable are considered ideal
% - all sensors are considered ideal
%%REM transformation

AB = RED.VP * VEH.R;
AB2 = AB*AB;
AB_INV = 1/AB;
AB_INV2 = AB_INV*AB_INV;

num = 144*(RED.pertes*AB2)/VEH.f; 
den =  [(VEH.J/VEH.f)+(VEH.MTOT*RED.pertes*AB2)/VEH.f 1];

transfert=tf(num,den);