/*
  POLYTECH LILLE
  IMA 5 PROJECT 5 2019/2020
  DELBROUCQ HUGO
  TARGET : Réalisation d'un banc de caractérisation d'un système mécatronique de type véhicule électrique
*/
#define BAUD_RATE 9600  //Serial communication baudrate 
#define MIN_VOL  77     //1.5V
#define MAX_VOL 153       //3V max voltage for motor
//Voltage command
const int pin_PWM_CTRL_MOTOR = 9;
const int pin_DO_SWITCH_BATT = 7;
const int pin_DO_SWITCH_CELL = 8;
const int pin_AI_I_CELL = A0;
const int pin_AI_U_CELL = A1;
const int pin_DO_LED = 3;
int PWM_CTRL_MOTOR;   //send a PWM signal to the motor driver
int DO_SWITCH_BATT;   //If 1, battery is selected
int DO_SWITCH_CELL;   //If 1, solar cell is selected
int DO_LED = HIGH;         //1 light is on
extern unsigned int AI_I_CELL;   //current value from the solar cell
extern unsigned int AI_U_CELL;   //voltage value from the solar cell


void setup() {
  Serial.begin(BAUD_RATE);
  pinMode(pin_PWM_CTRL_MOTOR, OUTPUT);
  pinMode(pin_PWM_CTRL_MOTOR, OUTPUT);
  pinMode(pin_DO_SWITCH_BATT, OUTPUT);
  pinMode(pin_DO_SWITCH_CELL, OUTPUT);
  pinMode(pin_DO_LED, OUTPUT);
  pinMode(pin_AI_I_CELL, INPUT);
  pinMode(pin_AI_U_CELL, INPUT);
  DO_SWITCH_BATT = 0;
  DO_SWITCH_CELL = 1 - DO_SWITCH_BATT;
  digitalWrite(pin_DO_LED, DO_LED);
  digitalWrite(pin_DO_SWITCH_BATT, DO_SWITCH_BATT);
  digitalWrite(pin_DO_SWITCH_CELL, DO_SWITCH_CELL);
  analogWrite(pin_PWM_CTRL_MOTOR, MAX_VOL);

}

void loop() {

  Serial.print("Tension cellule : ");
  float U_cell = (analogRead(pin_AI_U_CELL) *  5.0 / 1024.0) * (5.0 / 2.0) ;
  Serial.println(U_cell);
  Serial.print("Courant cellule : ");
  float I_cell = (analogRead(pin_AI_I_CELL) *  5.0 / 1024.0) / (200 * 0.025) ;
  Serial.println(I_cell);
  float P_cell = U_cell*I_cell;
  if (U_cell > 1.5 && P_cell > 3) {
    DO_SWITCH_BATT = 0;
    DO_SWITCH_CELL = 1 - DO_SWITCH_BATT;
    digitalWrite(pin_DO_SWITCH_BATT, DO_SWITCH_BATT);
    digitalWrite(pin_DO_SWITCH_CELL, DO_SWITCH_CELL);
    analogWrite(pin_PWM_CTRL_MOTOR, int(3 * 256 / U_cell));
  }
  else {
    DO_SWITCH_CELL = 0;
    DO_SWITCH_BATT = 1 - DO_SWITCH_CELL;
    digitalWrite(pin_DO_SWITCH_BATT, DO_SWITCH_BATT);
    digitalWrite(pin_DO_SWITCH_CELL, DO_SWITCH_CELL);
    analogWrite(pin_PWM_CTRL_MOTOR, MAX_VOL);
  }
  Serial.print(DO_SWITCH_BATT);
}
