<!DOCTYPE html>
<html id="html">
	<head>
		<meta charset="utf-8" />
        <title>Meteo</title>
		<link rel="stylesheet" type="text/css" href="style/style.css">
		<link rel="stylesheet" type="text/css" href="style/style_meteo.css">
		<script type="text/javascript" src="script/scripts.js"></script>
		<script type="text/javascript" src="script/jquery.js"></script>
		<script type="text/javascript" src="script/jweather.js"></script>
		<script type="text/javascript" src="script/jsweetalert.js"></script>
		<link rel="stylesheet" type="text/css" href="style/style_sweetalert.css">
		<?php Include('script/rotation.php'); ?>
	</head>

	<body onload="retourne()"><!-- Il faut ajouter l'appelle a la fonction retourne au chargement de la page pour eviter un bug d'appui sur le bouton -->
		<div id="entete">
			<img src="img/accueil.png" class="bouton_entete" onclick="self.location.href='index.php'">
			<img src="img/rotation.png" class="bouton_entete" onclick="retourne()">
			<p id="titre">
				<!-- Titre de la page affichee dans l'entete -->
				Meteo
			</p>
			<img src="img/aide.png" class="bouton_entete_help" onclick="swal('Aide', 'La météo en temps réelle de Lille.','info');">
		</div>
		<div id="contenu">
			<!-- Le contenu doit etre écrit ci-dessous -->
			<div id="meteo">
				<div id="weather"></div>
				<script type="text/javascript">
					// Docs at http://simpleweatherjs.com
					$(document).ready(function() {
					  $.simpleWeather({
					    location: 'LILLE, NORD-PAS-DE-CALAIS',
					    woeid: '608105',
					    unit: 'c',
					    success: function(weather) {
					      html = '<h2><i class="icon-'+weather.code+'"></i> '+weather.temp+'&deg;'+weather.units.temp+'</h2>';
					      html += '<ul><li>'+weather.city+', '+weather.region+'</li>';
					      html += '<li class="currently">'+weather.currently+'</li>';
					      html += '<li>'+weather.wind.direction+' '+weather.wind.speed+' '+weather.units.speed+'</li></ul>';
					  
					      $("#weather").html(html);
					    },
					    error: function(error) {
					      $("#weather").html('<p>'+error+'</p>');
					    }
					  });
					});
				</script>
			</div>
		</div>
	</body>
</html>
<!-- Attention si la meteo ne s'affiche plus, il faut verifier si il n'y a pas de mise a jour du plugin sur le site : http://simpleweatherjs.com/ -->
