#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdio.h>
#include <stdbool.h>

#include "serial.h"
#include "ethernet.h"
#include "socket.h"
#include "analog.h"
#include "var.h"
#include "digital.h" 

#include "light_ws2812.h"

#define MAXPIX 30
struct cRGB led[MAXPIX];

void init_led(void){
	uint8_t i;
    for (i=0 ; i < MAXPIX ; i++){  
        led[i].r=255;
        led[i].g=255;
        led[i].b=255;
    }
    ws2812_sendarray((uint8_t *)led,MAXPIX*3);
}

void set_led(uint8_t rouge, uint8_t vert, uint8_t bleu){
	uint8_t i;
    for (i=0 ; i < MAXPIX ; i++){
    	led[i].r = rouge;
    	led[i].g = vert;
    	led[i].b = bleu;
    }
    ws2812_sendarray((uint8_t *)led,MAXPIX*3);
}

void decap_data(uint8_t tab_data[SIZE_DATA]){
  	if ( tab_data[0] == 0x10){
  		set_led((uint8_t)tab_data[1],(uint8_t)tab_data[2],(uint8_t)tab_data[3]);
  		_delay_ms(100);
  	}
  	else {
  		set_led(0,0,0);
  	}
  		
}

int main(void){
	// tab
	uint8_t tab_data[SIZE_DATA];
	uint8_t tab_rec[SIZE_DATA+SIZE_UDP+SIZE_IP];

	// init serial
	init_serial(9600);

	// init GPIO
	output_init();

	init_led();

	int z=0;
	//int x=0;

	while(1){
		stock_packet(tab_rec, (SIZE_DATA+SIZE_UDP+SIZE_IP));
		/* TEST d'envoi de la trame reçue pour verification
			for(x=0; x<(SIZE_DATA+SIZE_UDP+SIZE_IP); x++){
				send_packet(tab_rec[x]);
			}
			send_serial(END);
		*/

		//decap_trame(tab_rec, tab_data);
		for (z = 0; z < SIZE_DATA; z++){
			tab_data[z]=tab_rec[SIZE_IP+SIZE_UDP+z];
		}
		decap_data(tab_data);
	}
	
	return 0;
}