//
//  math_io.cpp
//  ARToolKit5
//
//  This file is part of ARToolKit.
//
//  ARToolKit is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  ARToolKit is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with ARToolKit.  If not, see <http://www.gnu.org/licenses/>.
//
//  As a special exception, the copyright holders of this library give you
//  permission to link this library with independent modules to produce an
//  executable, regardless of the license terms of these independent modules, and to
//  copy and distribute the resulting executable under terms of your choice,
//  provided that you also meet, for each linked independent module, the terms and
//  conditions of the license of that module. An independent module is a module
//  which is neither derived from nor based on this library. If you modify this
//  library, you may extend this exception to your version of the library, but you
//  are not obligated to do so. If you do not wish to do so, delete this exception
//  statement from your version.
//
//  Copyright 2013-2015 Daqri, LLC.
//
//  Author(s): Chris Broaddus
//

#include "math_io.h"
#include "indexing.h"

namespace vision {

    void PrintBinaryString(const unsigned char* bitstring, int size, const char* str) {
        printf("%s = [", str);
        for(int i = 0; i < size; i++) {
            printf("%d ", bitstring_get_bit(&bitstring[i], 0));
            printf("%d ", bitstring_get_bit(&bitstring[i], 1));
            printf("%d ", bitstring_get_bit(&bitstring[i], 2));
            printf("%d ", bitstring_get_bit(&bitstring[i], 3));
            printf("%d ", bitstring_get_bit(&bitstring[i], 4));
            printf("%d ", bitstring_get_bit(&bitstring[i], 5));
            printf("%d ", bitstring_get_bit(&bitstring[i], 6));
            
            if(i == size-1) {
                printf("%d", bitstring_get_bit(&bitstring[i], 7));
            } else {
                printf("%d ", bitstring_get_bit(&bitstring[i], 7));
            }
        }
        printf("]\n");
    }
    
} // vision