-- création des tables --
drop table if exists SUGGESTION;
drop table if exists COMMANDE;
drop table if exists SOIREE;
drop table if exists INFO;
drop table if exists PRODUIT;
drop table if exists CONSOLE;
drop table if exists CLIENT;
drop table if exists PERSONNEL;


create table PERSONNEL (
	id_personnel serial NOT NULL PRIMARY KEY,
	login text NOT NULL,
	pass_hash text NOT NULL,
	fonction varchar(10));

create table CLIENT (
	id_client serial NOT NULL PRIMARY KEY,
	name varchar(20));

create table CONSOLE (
	id_table serial NOT NULL PRIMARY KEY,
	serveur int REFERENCES PERSONNEL,
	localisation varchar(20));

create table PRODUIT (
	id_produit serial NOT NULL PRIMARY KEY,
	nom varchar(50) NOT NULL,
	type varchar(20) NOT NULL,
	prix numeric CHECK (prix >= 0),
	dispo varchar(5),
	temps numeric CHECK (temps >= 0),
	information varchar(100),
	img varchar(100));

create table INFO (
	id_info serial NOT NULL PRIMARY KEY,
	conso int REFERENCES PRODUIT,
	texte text);

create table SOIREE (
	id_soiree serial NOT NULL PRIMARY KEY,
	console int REFERENCES CONSOLE,
	client int REFERENCES CLIENT);

create table COMMANDE (
	id_commande serial NOT NULL PRIMARY KEY,
	conso int REFERENCES PRODUIT,
	soiree int REFERENCES SOIREE,
	nombre int,
	suggestion varchar(5),
	etat varchar(10),
	paiement varchar(5),
	type_paiement varchar(10),
	num_cmd int);

create table SUGGESTION (
	id_suggestion serial NOT NULL PRIMARY KEY,
	conso_base int REFERENCES PRODUIT,
	conso_sugg int REFERENCES PRODUIT,
	prix numeric CHECK (prix >= 0));

create table QUESTIONNAIRE1 (
	id_questionnaire1 serial NOT NULL PRIMARY KEY,
	formation varchar(50) NOT NULL,
	professeur varchar(50),
	alternant varchar(50),
	annee varchar(50),
	chx1 numeric,
	chx2 numeric,
	chx3 numeric,
	chx4 numeric,
	chx5 numeric,
	chx6 numeric,
	choix_autre text);

-- Peuplement BDD

insert into PERSONNEL( login, pass_hash, fonction) values ('admin', '$2y$10$Kl5zLoVCmHx6BDyhLv2VmeL4MDx6ABNQz8iY0mjs80bVmsjpvm4XO','admin');
insert into PERSONNEL( login, pass_hash, fonction) values ('bar', '$2y$10$mpvNFtz8piCxfRCVXUAv2.5RFXYtiJtVJhtxptduxJJ9txglSyKsC','barman');
insert into PERSONNEL( login, pass_hash, fonction) values ('serveur', '$2y$10$JJXCqBzcYM1m0f92UzPKauFnLyp8M./QHdcFtmhCdjo.BSV3A/cjq','serveur');

insert into CLIENT ( name) values ('test');

insert into CONSOLE ( serveur, localisation) values ('3', 'fond');





-- Bières
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Guinness', 'Bières', '5', 'true', '60', 'Stout / Noire - 5° - 25cl', 'guinness.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Leffe ruby', 'Bières', '3', 'true', '60', 'Fruit Beer - 5° - 33cl', 'leffe_ruby.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Levrette', 'Bières', '4', 'true', '30', 'Lager / Blonde - 5° - 33cl', 'levrette.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Delirium Tremens', 'Bières', '4', 'true', '40', 'Belgian Pale Ale / Blonde - 8,5° - 33cl', 'delirium_tremens.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Rince Cochon', 'Bières', '3', 'true', '40', 'Belgian Pale Ale / Blonde - 8,5° - 33cl', 'rince_cochon.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Kwak', 'Bières', '3', 'true', '40', 'Belgian Pale Ale / Blonde - 8,1° - 33cl', 'kwak.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Karmeliet Triple', 'Bières', '3', 'true', '40', 'Tripel - 8° - 33cl', 'karmeliet_triple.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Cuvée des Trolls', 'Bières', '2', 'true', '40', 'Belgian Pale Ale / Blonde - 7° - 25cl', 'cuvee_des_trolls.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('La Chouffe', 'Bières', '3', 'true', '40', 'Belgian Pale Ale / Blonde - 8° - 33cl', 'la_chouffe.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Barista Chocolate Quad', 'Bières', '3', 'true', '40', 'Quadrupel / Brune - 11° - 33cl', 'barista_chocolate_quad.png');

-- Cocktails
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Jäger Club', 'Cocktails', '5', 'true', '40', 'Jägermeister - Eau gazeuse', 'jager_club.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Mojito', 'Cocktails', '5', 'true', '100', 'Rhum cubain - Citrons verts - Menthe - Eau gazeuse - Sucre de canne', 'mojito.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Daiquiri', 'Cocktails', '5', 'true', '60', 'Rhum cubain - Citrons verts - Sucre de canne', 'daiquiri.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Piña Colada', 'Cocktails', '5', 'true', '80', 'Rhum blanc - Rhum ambré - Jus d''ananas - Lait de coco', 'pina_colada.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Margarita', 'Cocktails', '5', 'true', '60', 'Tequila - Triple sec - Citrons verts', 'margarita.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Cosmopolitan', 'Cocktails', '5', 'true', '80', 'Vodka - Triple sec - Cramberry - Citrons verts', 'cosmopolitan.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Caipirinha', 'Cocktails', '5', 'true', '60', 'Cachaça - Citron vert - Sucre', 'caipirinha.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Cuba Libre', 'Cocktails', '5', 'true', '60', 'Rhum cubain - Citrons verts - Coca Cola', 'cuba_libre.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Tequila Sunrise', 'Cocktails', '5', 'true', '60', 'Tequila - Jus d''orange - Sirop de grenadine', 'tequila_sunrise.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Blue Lagoon', 'Cocktails', '5', 'true', '60', 'Vodka - Curaçoa bleu - Jus de citron', 'blue_lagoon.png');

-- Sauvissons  http://www.saucissons-secs.fr/specialite/
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Nature', 'Saucissons', '7', 'true', '30', 'Pur porc - 170gr', 'saucisson_nature.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Fumé', 'Saucissons', '7', 'true', '30', 'Pur porc - 170gr', 'saucisson_fume.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('provençal', 'Saucissons', '7', 'true', '30', 'Pur porc - 170gr', 'saucisson_provencal.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Enrobé au poivre', 'Saucissons', '7', 'true', '30', 'Pur porc - 170gr', 'saucisson_poivre.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Tomate séchée', 'Saucissons', '7', 'true', '30', 'Pur porc - 170gr', 'saucissinitdb --locale=sv_SEon_tomate.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Figue', 'Saucissons', '7', 'true', '30', 'Pur porc - 170gr', 'saucisson_figue.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Âne', 'Saucissons', '7', 'true', '30', 'Viande de gibier - 170gr', 'saucisson_ane.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Sanglier', 'Saucissons', '7', 'true', '30', 'Viande de gibier - 170gr', 'saucisson_sanglier.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Canard', 'Saucissons', '7', 'true', '30', 'Viande de gibier - 170gr', 'saucisson_canard.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Comté', 'Saucissons', '7', 'true', '30', 'Pur porc avec du fromage - 170gr', 'saucisson_comte.png');

-- Soft 
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Red Bull', 'Soft', '4', 'false', '30', 'Boisson énergisante - 25cl', 'red_bull.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Monster', 'Soft', '4', 'false', '30', 'Boisson énergisante - 25cl', 'monster.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Fïnley', 'Soft', '3', 'false', '30', 'Citron - Fleur de sureau - 25cl', 'finley.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Perrier', 'Soft', '3', 'false', '30', 'Boisson gazeuse - 33cl', 'perrier.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Evian', 'Soft', '3', 'false', '30', 'Eau plate - 20cl', 'evian.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Ice Tea - Pêche', 'Soft', '2', 'false', '30', 'Boisson non-gazeuse - 33cl', 'ice_tea.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Coca Cola', 'Soft', '2', 'false', '30', 'Boisson gazeuse - 33cl', 'coca_cola.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Fanta - Orange', 'Soft', '2', 'false', '30', 'Boisson gazeuse - 33cl', 'fanta.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Jus de pomme', 'Soft', '3', 'false', '30', 'Caraïbos - 25cl', 'jus_de_pomme.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Jus d''ananas', 'Soft', '4', 'false', '30', 'Caraïbos - 25cl', 'jus_de_ananas.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Diabolo violette', 'Soft', '4', 'false', '30', 'Boisson gazeuse - 33cl', 'diabolo_violette.png');

-- Fromage
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Comté', 'Fromages', '5', 'true', '30', '18 mois d''affinage - 125gr', 'fromage_comte.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Gruyère', 'Fromages', '5', 'true', '30', 'Suisse - 125gr', 'fromage_gruyere.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Beaufort', 'Fromages', '7', 'true', '30', 'Beaufort Chalet d''Alpage - 125gr', 'fromage_beaufort.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Tome des Bauges', 'Fromages', '5', 'true', '30', '125gr', 'fromage_tome_des_bauges.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Mimolette', 'Fromages', '5', 'true', '30', 'Mimolette extra vielle - 125gr', 'fromage_mimolette.png');


-- Tapas http://www.lastapas.fr/carte.php?menu=menu1
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Chorizo a la''asturiana', 'Tapas', '3', 'true', '60', 'Chorizo à l''asturienne', 'tapas_chorizo.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Croquetas de jamón serrano', 'Tapas', '3', 'true', '60', 'Croquettes de jambon serrano', 'tapas_jambon.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Costillas de cerdo asadas al horno', 'Tapas', '3', 'true', '60', 'Travers de porc', 'tapas_porc.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Tortilla', 'Tapas', '3', 'true', '60', 'Omelette Espagnole', 'tapas_tortilla.png');
	insert into PRODUIT ( nom, type, prix, dispo, temps, information, img) values ('Tostada de queso', 'Tapas', '3', 'true', '60', 'Toast au fromage manchego et thym', 'tapas_fromage.png');

-- ajout info

insert into SOIREE ( console, client) values ('1', '1');
insert into SOIREE ( console, client) values ('1', '1');

insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('1', '22','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('1', '28','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('1', '42','4');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('3', '23','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('3', '21','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('3', '43','4');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('5', '30','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('5', '29','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('5', '46','4');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('6', '26','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('6', '28','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('6', '44','4');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('7', '27','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('7', '24','6');
insert into SUGGESTION ( conso_base, conso_sugg, prix) values ('7', '45','4');

INSERT INTO info VALUES (2, 1, 'La Guinness est née à la brasserie Arthur Guinness près de la porte St. James de Dublin (Irlande). Cette bière est un stout, un type de bière de fermentation haute issue des bières porter devenues célèbres au XVIIIe siècle à Londres (Royaume-Uni). Sa couleur brune presque noire (mais qui est en fait rouge profond ; à voir à la lumière) provient de l''utilisation pour sa conception de malts hautement torréfiés et de grains d''orges grillés. La couche de mousse couleur crème qui coiffe la bière est le résultat d''un ajout d''azote durant le tirage (service à la pression). Cette dernière caractéristique pose la difficulté d''obtenir une saveur et une texture identique entre les Guinness servies à la pression et celles vendues en bouteilles et canettes. La Guinness est extrêmement populaire en Irlande. Elle représente la première boisson alcoolisée vendue dans le pays1. Même si elle est culturellement liée à l''Irlande, il s''agit d''une des bières les plus célèbres au monde, s''exportant aux quatre coins du globe (notamment avec sa gamme Foreign Extra Stout). La société mère historique (Guinness UDV) est installée à Londres depuis 1932. Depuis 2001 la bière a été distribuée à l''échelle globale par la multinationale Diageo. La France fait exception depuis le premier juillet 2007, car ce sont les Brasseries Kronenbourg (elles-mêmes appartenant à Carlsberg Group depuis le 29 avril 2008) qui sont le distributeur de la bière.');
INSERT INTO info VALUES (3, 2, 'Du nom de l''Abbaye de Leffe située sur la commune de Dinant en Belgique (à ne pas confondre avec Neffe qui est sur l''autre rive) dans la vallée de la Meuse, la bière de Leffe fait partie de la variété des bières d''abbaye. Cette bière a été créée par les chanoines prémontrés, installés à Leffe depuis 1152, qui achètent en 1240 au clerc Gossuin et en présence des échevins de Dinant, divers biens dont une brasserie 1. Au Moyen Âge, dans l’impossibilité de vérifier si l’eau de source était saine, les moines trouvaient dans la fabrication de bière un moyen précieux d''échapper aux épidémies (grâce au processus assainissant de la fermentation) et rapidement on transféra le moulin et sa brasserie dans l''enceinte même de l''abbaye. À la suite de la destruction de la brasserie pendant la Révolution française, la production de bière s''arrêta. En 1952, le brasseur Lootvoet obtint les droits de licence pour produire la bière de Leffe. En 1955, cette brasserie a été rachetée par les brasseries Stella Artois. En 1975, elle ferma et toute la production fut transférée à la Brasserie Grade de Mont Saint Guibert (plus tard, nommée brasserie Saint Guibert). En 1975, la production s''élevait à 18 000 hl par an ; quand Saint Guibert ferma le 30 juin 1996, la production s''élevait alors à plus de 300 000 hl et partit à Louvain. Elle fait maintenant partie du groupe AB InBev et elle est toujours brassée en Belgique à Louvain. Quand aux fondateurs, les chanoines prémontrés, ils sont toujours présents dans l''Abbaye de Leffe, dans six abbayes en Belgique et deux en France.');
INSERT INTO info VALUES (4, 3, 'Début 2008, l’idée de brasser une bière au nom populaire devenait de plus en plus évidente.  Notre volonté était de concilier humour et produit de qualité. C’est ainsi qu’est née la « Levrette ».  Une bière blonde brassée selon une méthode artisanale. Légère et digeste, elle est parfumée par des houblons aromatiques et légèrement épicés. Elle obtient même la médaille d’or au Mondial de la bière de Strasbourg en 2010 ! Sa mascotte ? Le lapin Ret !');
INSERT INTO info VALUES (5, 4, 'La Delirium Tremens a vu le jour le 26 décembre 1989. La bière, titrant 8,5 %, nécessite trois levures différentes. Elle est emballée dans une bouteille à l''aspect de céramique, faisant penser à la poterie de Cologne. L''éléphant rose est une allusion à la conséquence d''un delirium tremens, dont l''étiquette dépeint les différentes phases. Les oiseaux situés en haut et en bas de l''étiquette sont une référence au film Les Oiseaux d''Alfred Hitchcock. Elle offre des pointes d''amertume et dévoile au nez une odeur maltée. Sa conclusion se conjugue sur un ton amer et poivré. En 1992, la « Confrérie de l’Éléphant Rose » a été créée pour promouvoir la Delirium Tremens et autres bières de Melle. En 1997, elle est sacrée championne du monde des bières par le chasseur de bières américain Stuart A. Kallen. Cette distinction est confirmée l''année suivante par une médaille d''or reçue lors du « World Beer Championship » de Chicago.');
INSERT INTO info VALUES (6, 5, 'La Rince Cochon est une bière à façon blonde à l''origine française mais actuellement brassée en Belgique pour le compte d''une société française. C''est une bière de fermentation haute, possédant un haut degré d''alcool (8,5 % alc./vol.). Elle est fabriquée à partir d''eau, de malt, de houblon, d''orge, et de levure. La Rince Cochon a été conçue par le brasseur SBA et brassée par les brasseries Huyghe (2008-2009) et Haacht (depuis 2010). À la suite de la faillite de la société Artisans de la bière, elle est commercialisée par la société Difcom.');
INSERT INTO info VALUES (7, 6, 'Ambrée, la bière Kwak est brassée par la brasserie Bosteels. Son taux d''alcool est de 8,4 %. Sa particularité est d''être servie dans un verre à la forme particulière, le « verre à cocher ». Selon la brasserie, ce verre aurait été créé à l''intention de ces derniers, sa forme leur permettant d''accrocher le verre à la calèche pour la consommer sans en descendre. La légende veut que le nom de la bière provienne du bruit que l''on entend quand on boit son verre cul-sec, et que l''air remonte dans celui-ci, laissant entendre le fameux « kwak ». Il s''agit en fait du nom de l''inventeur de la bière, en 1791, le brasseur Pauwel Kwak aussi appelé Teddy Kwak.');
INSERT INTO info VALUES (8, 7, 'La Tripel Karmeliet (Triple Carmélite en français) est une bière belge lancée en 1996 selon une recette originale de 1679. C''est une bière de fermentation haute, possédant un haut degré d''alcool (8,4 % alc./vol.). Elle est fabriquée à partir de trois céréales : l''orge, le froment et l''avoine. L''anecdote veut qu''elle ait été élaborée à partir d''une recette des moines carmélites de Termonde au XVIIe siècle, d''où son nom de Tripel Karmeliet. Elle est brassé selon la même recette depuis 1679. Cette recette provient à l’origine de l’ancien couvent des Carmes à Termonde. Créée il y a plus de 300 ans, cette recette prescrit l’utilisation de trois sortes de céréales : le froment, l’avoine et l’orge. Le nom Tripel Karmeliet fait référence à cette originalité mais aussi à sa fermentation en bouteille.');
INSERT INTO info VALUES (9, 8, 'La Cuvée des Trolls est une bière brassée aux Brasseries Dubuisson Frères à Pipaix en Belgique et également par les micro-brasseries Brasse-Temps de Louvain-la-Neuve et de Mons. Son logo est un petit personnage figurant un troll au nez pointu coiffé d''un chapeau vert. Il s''agit d''une bière blonde, filtrée ou non filtrée, fraîche et parfumée, particulièrement ronde et bien équilibrée, et titrant 7,5 % de volume alcool. Elle est brassée à partir de moût sucré auquel on rajoute du houblon et des écorces d''orange séchées. Il s''agit d''une fermentation haute (température de fermentation 23 °C pendant une semaine). La bière brassée par les Brasse-Temps n''est pas filtrée et juste décantée: il reste donc un peu de levure qui est servie au consommateur. il est conseillé de la servir à 3 °C. Elle est conditionnée en bouteille ainsi qu''en fût. Au dos de l''étiquette des bouteilles se trouvent des gages que les consommateurs sont invités à réaliser. ');
INSERT INTO info VALUES (10, 9, 'LA CHOUFFE est une Bière blonde non filtrée, refermentée aussi bien en bouteille qu’en fût. Elle est agréablement fruitée, épicée à la coriandre et légèrement houblonnée.');
INSERT INTO info VALUES (11, 10, 'La bière et le café, deux univers réunis dans la Barista. Les arômes et le goût de caramel, cacao et malt torréfié s''accordent avec ''l''or noir'' et le chocolat. Une bière qui évoque les boissons chaudes, avec l''alcool réchauffant dans l''arrière-goût. Les gourmets sont avertis. ');

