/** Functions for ethernet **/
#include <stdio.h>
#include <stdbool.h>

#include "var.h"
#include "ethernet.h"
#include "analog.h"

bool decap_trame(uint8_t tab_rec[SIZE_DATA+SIZE_UDP+SIZE_IP], uint8_t *tab_data){
	int i;


	// VERIF IP
	if ( tab_rec[0] != 0x45 ) // Verif trame IP
		return false;
	if ( tab_rec[16] != ((uint8_t)(IP_BASE >> 24)) ) // Verif IP part 1
		return false;
	if ( tab_rec[17] != ((uint8_t)(IP_BASE >> 16)) ) // Verif IP part 2
		return false;
	if ( tab_rec[18] != ((uint8_t)(IP_BASE >> 8)) ) // Verif IP part 3
		return false;
	if ( tab_rec[19] != ((uint8_t)(IP_BASE)) )// Verif IP part 4
		return false;
	
	// VERIF UDP
	/*
	if ( tab_rec[SIZE_IP] != ((uint8_t)(UDP_SRC >> 8)) ) // verif port UDP src 1 
		return false;
	if ( tab_rec[SIZE_IP + 1] != ((uint8_t)UDP_SRC) ) // verif port UDP src
		return false;
	*/
	if ( tab_rec[SIZE_IP + 2] != ((uint8_t)(UDP_DEST >> 8)) ) // verif port UDP dest 1
		return false;
	if ( tab_rec[SIZE_IP + 3] != ((uint8_t)UDP_DEST) ) // verif port UDP dest
		return false;
	
	// recup paquet
	for (i = 0; i < SIZE_DATA; i++)
		tab_data[i]=tab_rec[SIZE_IP+SIZE_UDP+i];

	return true;
}
