#include <avr/io.h>
#include "digital.h"

void output_init(void){
	DDRB |= 0xFF;
}

void input_init(void){
	/*
	DDRD &= 0xfb;  // PIN 2 as input
	PORTD |= 0x04; // Pull-up activated on PIN 2
	*/
}

void output_set(unsigned char value){
	if(value==0) PORTB &= 0xfe; else PORTB |= 0x01;
}

unsigned char input_get(void){
	return ((PIND&0x04)!=0)?1:0;
}