<!DOCTYPE html>
<html id="html">
    <head>
        <meta charset="utf-8" />
        <title>Jeu</title>
        <link rel="stylesheet" type="text/css" href="style/style.css">
        <script type="text/javascript" src="script/scripts.js"></script>
        <script type="text/javascript" src="script/jquery.js"></script>
        <script type="text/javascript" src="script/jkonva.js"></script>
        <script type="text/javascript" src="script/jsweetalert.js"></script>
        <link rel="stylesheet" type="text/css" href="style/style_sweetalert.css">
        <?php Include('script/rotation.php'); ?>
    </head>

    <body onload="retourne()"><!-- Il faut ajouter l'apelle a la fonction retourne au chargement de la page pour eviter un bug d'appui sur le bouton -->
        <div id="entete">
            <img src="img/accueil.png" class="bouton_entete" onclick="self.location.href='index.php'">
            <img src="img/retour.png" class="bouton_entete" onclick="javascript:history.go(-1)">
            <img src="img/rotation.png" class="bouton_entete" onclick="retourne()">
            <p id="titre">
                <!-- Titre de la page affichee dans l'entete -->
                Jeu
            </p>
            <img src="img/aide.png" class="bouton_entete_help" onclick="swal('Aide', 'Un petit jeu éveil pour enfant. \n Il suffit de déplacer les animaux dans leur ombre.','info');">
        </div>
        <div id="contenu">
            <!-- Le contenu doit etre écrit ci-dessous -->
            <div id="container"></div>
            <script>
                var width = window.innerWidth;
                var height = window.innerHeight;

                function loadImages(sources, callback) {
                    var assetDir = 'http://konvajs.github.io/assets/';
                    var images = {};
                    var loadedImages = 0;
                    var numImages = 0;
                    for(var src in sources) {
                        numImages++;
                    }
                    for(var src in sources) {
                        images[src] = new Image();
                        images[src].onload = function() {
                            if(++loadedImages >= numImages) {
                                callback(images);
                            }
                        };
                        images[src].src = assetDir + sources[src];
                    }
                }
                function isNearOutline(animal, outline) {
                    var a = animal;
                    var o = outline;
                    var ax = a.getX();
                    var ay = a.getY();

                    if(ax > o.x - 20 && ax < o.x + 20 && ay > o.y - 20 && ay < o.y + 20) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
                function drawBackground(background, beachImg, text) {
                    var context = background.getContext();
                    context.drawImage(beachImg, 0, 0);
                    context.setAttr('font', '20pt Calibri');
                    context.setAttr('textAlign', 'center');
                    context.setAttr('fillStyle', 'white');
                    context.fillText(text, background.getStage().getWidth() / 2, 40);
                }

                function initStage(images) {
                    var stage = new Konva.Stage({
                        container: 'container',
                        width: 578,
                        height: 530
                    });
                    var background = new Konva.Layer();
                    var animalLayer = new Konva.Layer();
                    var animalShapes = [];
                    var score = 0;

                    // image positions
                    var animals = {
                        snake: {
                            x: 10,
                            y: 70
                        },
                        giraffe: {
                            x: 90,
                            y: 70
                        },
                        monkey: {
                            x: 275,
                            y: 70
                        },
                        lion: {
                            x: 400,
                            y: 70
                        }
                    };

                    var outlines = {
                        snake_black: {
                            x: 275,
                            y: 350
                        },
                        giraffe_black: {
                            x: 390,
                            y: 250
                        },
                        monkey_black: {
                            x: 300,
                            y: 420
                        },
                        lion_black: {
                            x: 100,
                            y: 390
                        }
                    };

                    // create draggable animals
                    for(var key in animals) {
                        // anonymous function to induce scope
                        (function() {
                            var privKey = key;
                            var anim = animals[key];

                            var animal = new Konva.Image({
                                image: images[key],
                                x: anim.x,
                                y: anim.y,
                                draggable: true
                            });



                            animal.on('dragstart', function() {
                                this.moveToTop();
                                animalLayer.draw();
                            });
                            /*
                                   * check if animal is in the right spot and
                                   * snap into place if it is
                                   */
                            animal.on('dragend', function() {
                                var outline = outlines[privKey + '_black'];
                                if(!animal.inRightPlace && isNearOutline(animal, outline)) {
                                    animal.position({
                                        x : outline.x,
                                        y : outline.y
                                    });
                                    animalLayer.draw();
                                    animal.inRightPlace = true;

                                    if(++score >= 4) {
                                        var text = 'You win! Enjoy your booty!';
                                        drawBackground(background, images.beach, text);
                                    }

                                    // disable drag and drop
                                    setTimeout(function() {
                                        animal.draggable(false);
                                    }, 50);
                                }
                            });
                            // make animal glow on mouseover
                            animal.on('mouseover', function() {
                                animal.image(images[privKey + '_glow']);
                                animalLayer.draw();
                                document.body.style.cursor = 'pointer';
                            });
                            // return animal on mouseout
                            animal.on('mouseout', function() {
                                animal.image(images[privKey]);
                                animalLayer.draw();
                                document.body.style.cursor = 'default';
                            });

                            animal.on('dragmove', function() {
                                document.body.style.cursor = 'pointer';
                            });

                            animalLayer.add(animal);
                            animalShapes.push(animal);
                        })();
                    }

                    // create animal outlines
                    for(var key in outlines) {
                        // anonymous function to induce scope
                        (function() {
                            var imageObj = images[key];
                            var out = outlines[key];

                            var outline = new Konva.Image({
                                image: imageObj,
                                x: out.x,
                                y: out.y
                            });

                            animalLayer.add(outline);
                        })();
                    }

                    stage.add(background);
                    stage.add(animalLayer);

                    drawBackground(background, images.beach, 'Ahoy! Put the animals on the beach!');
                }

                var sources = {
                    beach: 'beach.png',
                    snake: 'snake.png',
                    snake_glow: 'snake-glow.png',
                    snake_black: 'snake-black.png',
                    lion: 'lion.png',
                    lion_glow: 'lion-glow.png',
                    lion_black: 'lion-black.png',
                    monkey: 'monkey.png',
                    monkey_glow: 'monkey-glow.png',
                    monkey_black: 'monkey-black.png',
                    giraffe: 'giraffe.png',
                    giraffe_glow: 'giraffe-glow.png',
                    giraffe_black: 'giraffe-black.png'
                };
                loadImages(sources, initStage);
              </script>

        </div>
    </body>
</html>
