<!DOCTYPE html>
<html id="html">
	<head>
		<meta charset="utf-8" />
        <title>Dessin</title>
		<link rel="stylesheet" type="text/css" href="style/style.css">
		<link rel="stylesheet" href="style/style_draw.css">
		<script type="text/javascript" src="script/scripts.js"></script>
		<script type="text/javascript" src="script/jquery.js"></script>
		<script type="text/javascript" src="script/jsweetalert.js"></script>
		<link rel="stylesheet" type="text/css" href="style/style_sweetalert.css">
		<script src="script/jkonva.js"></script>
		<?php Include('script/rotation.php'); ?>

	</head>

	<body onload="retourne()"><!-- Il faut ajouter l'apelle a la fonction retourne au chargement de la page pour eviter un bug d'appui sur le bouton -->
		<div id="entete">
            <img src="img/accueil.png" class="bouton_entete" onclick="self.location.href='index.php'">
            <img src="img/retour.png" class="bouton_entete" onclick="javascript:history.go(-1)">
            <img src="img/rotation.png" class="bouton_entete" onclick="retourne()">
			<p id="titre">
				<!-- Titre de la page affichee dans l'entete -->
				Dessin
			</p>
			<img src="img/aide.png" class="bouton_entete_help" onclick="swal('Aide', 'Libérez votre imagination sur cette toile blanche !','info');">
		</div>
		<div id="contenu">
			<!-- Le contenu doit etre écrit ci-dessous -->
				<label for=""> Tool : </label>

		  <select id="tool">
		    <option value="brush">Brush</option>
		    <option value="eraser">Eraser</option>
		  </select>
		  <div id="container"></div>
		  <script>
		    var width = window.innerWidth;
		    var height = window.innerHeight - 25;

		    // first we need Konva core things: stage and layer
		    var stage = new Konva.Stage({
		      container: 'container',
		      width: width,
		      height: height
		    });

		    var layer = new Konva.Layer();
		    stage.add(layer);


		    // then we are going to draw into special canvas element
		    var canvas = document.createElement('canvas');
		    canvas.width = stage.width() / 2;
		    canvas.height = stage.height() / 2;

		    // creted canvas we can add to layer as "Konva.Image" element
		    var image = new Konva.Image({
		        image: canvas,
		        x : stage.width() / 4,
		        y : stage.height() / 4,
		        stroke: '#ddd',
		        shadowBlur: 5
		    });
		    layer.add(image);
		    stage.draw();

		    // Good. Now we need to get access to context element
		    var context = canvas.getContext('2d');
		    context.strokeStyle = "#162354";
		    context.lineJoin = "round";
		    context.lineWidth = 5;


		    var isPaint = false;
		    var lastPointerPosition;
		    var mode = 'brush';


		    // now we need to bind some events
		    // we need to start drawing on mousedown
		    // and stop drawing on mouseup
		    stage.on('contentMousedown.proto', function() {
		      isPaint = true;
		      lastPointerPosition = stage.getPointerPosition();

		    });

		    stage.on('contentMouseup.proto', function() {
		        isPaint = false;
		    });

		    // and core function - drawing
		    stage.on('contentMousemove.proto', function() {

		      if (!isPaint) {
		        return;
		      }

		      if (mode === 'brush') {
		        context.globalCompositeOperation = 'source-over';
		      }
		      if (mode === 'eraser') {
		        context.globalCompositeOperation = 'destination-out';
		      }
		      context.beginPath();

		      var localPos = {
		        x: lastPointerPosition.x - image.x(),
		        y: lastPointerPosition.y - image.y()
		      };
		      context.moveTo(localPos.x, localPos.y);
		      var pos = stage.getPointerPosition();
		      localPos = {
		        x: pos.x - image.x(),
		        y: pos.y - image.y()
		      };
		      context.lineTo(localPos.x, localPos.y);
		      context.closePath();
		      context.stroke();


		      lastPointerPosition = pos;
		      layer.draw();
		    });



		    var select = document.getElementById('tool');
		    select.addEventListener('change', function() {
		      mode = select.value;
		    });

		  </script>

		</div>
	</body>
</html>
