#include <XBee.h>
#include <inttypes.h>

//pour indiquer l'action;
#define ALLUMER 0
#define ETEINDRE 1

enum status_t{allumee, eteindu};
typedef enum status_t status;

const uint8_t id_arduino_local = 'c';
const uint8_t id_arduino_dest = 'd';
const uint8_t id_arduino_previous = 'b';
uint8_t id_message = 0;

//pour controler les de l'id_arduino prochain
uint8_t action = ALLUMER;

uint8_t payload[] = {0,0,0}; //test -> {id_arduino,id_message,action};
uint8_t address_local = 0x02;
uint8_t address_dest  = 0x03;

status led_etat_self = eteindu;

struct message{
    uint8_t id_arduino;
    uint8_t id_message;
    uint8_t mes;
};
typedef struct message MESSAGE;


XBee xbee = XBee();


Tx16Request tx = Tx16Request(address_dest, payload, sizeof(payload));

TxStatusResponse txStatus = TxStatusResponse();

XBeeResponse response = XBeeResponse();
Rx16Response rx16 = Rx16Response();
Rx64Response rx64 = Rx64Response();

void sendMessageAllumer(){
    // start transmitting after a startup delay.  Note: this will rollover to 0 eventually so not best way to handle
    payload[0] = id_arduino_local;
    payload[1] = id_message;
    if(id_message == 255){
        id_message = 0;
    }
    else{
        id_message += 1;
    }
    payload[2] = ALLUMER;
    xbee.send(tx);
    if (xbee.readPacket(1000)) {
        if (xbee.getResponse().getApiId() == TX_STATUS_RESPONSE) {
            xbee.getResponse().getTxStatusResponse(txStatus);
            if (txStatus.getStatus() == SUCCESS) {
            } else {
            }
        }
    } else if (xbee.getResponse().isError()) {
    } else {
    }
}


void sendMessageEteindre(){
    payload[0] = id_arduino_local;
    payload[1] = id_message;
    if(id_message == 255){
        id_message = 0;
    }
    else{
        id_message += 1;
    }
    payload[2] = ETEINDRE;
    xbee.send(tx);
    // after sending a tx request, we expect a status response
    // wait up to 5 seconds for the status response
    if (xbee.readPacket(1000)) {
        // got a response!

        // should be a znet tx status
        if (xbee.getResponse().getApiId() == TX_STATUS_RESPONSE) {
            xbee.getResponse().getTxStatusResponse(txStatus);

            // get the delivery status, the fifth byte
            if (txStatus.getStatus() == SUCCESS) {
                // success.  time to celebrate
            } else {
            }
        }
    } else if (xbee.getResponse().isError()) {
    } else {
    }
}

MESSAGE getMessage(){
    xbee.readPacket();
    MESSAGE mes;
    mes.id_arduino = 0;
    mes.id_message = 0;
    mes.mes = 0;
    if (xbee.getResponse().isAvailable()) {

        if (xbee.getResponse().getApiId() == RX_16_RESPONSE || xbee.getResponse().getApiId() == RX_64_RESPONSE) {
            // got a rx packet

            if (xbee.getResponse().getApiId() == RX_16_RESPONSE) {
                xbee.getResponse().getRx16Response(rx16);
                //option = rx16.getOption();
                //data = rx16.getData(0);
                mes.id_arduino = rx16.getData(0);
                mes.id_message = rx16.getData(1);
                mes.mes = rx16.getData(2);
            }
        }
    }
    return mes;
}

void setup() {
    //    pinMode(statusLed, OUTPUT);
    //   pinMode(errorLed, OUTPUT);
    Serial.begin(9600);
    xbee.setSerial(Serial);
    pinMode(LED_BUILTIN, OUTPUT);
    digitalWrite(LED_BUILTIN, LOW);   // turn the LED on (HIGH is the voltage level)
}

void loop() {
    MESSAGE mes = getMessage();
    if(mes.id_arduino == id_arduino_previous){
        if(mes.mes == ALLUMER){
            digitalWrite(LED_BUILTIN, HIGH);   // turn the LED on (HIGH is the voltage level)
            led_etat_self = allumee;
            //delay(1000);
            //sendMessageAllumer();
        }
        else if(mes.mes == ETEINDRE){
            digitalWrite(LED_BUILTIN, LOW);   // turn the LED on (HIGH is the voltage level)
            led_etat_self = eteindu;
            //delay(1000);
            //sendMessageEteindre();
        }
    }
}
