    // #include <stdlib.h>
// #include <stdio.h>
// #include <SDL/SDL.h>
// #include <SDL/SDL_image.h>
#include <time.h>
#include <linux/input.h>
#include <linux/uinput.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "main.h"

#define SCREEN_WIDTH 1000
#define SCREEN_HEIGHT 600
#define DEBUG

/*

INDICE == Faire Varier la transparence

*/



int isMenu = 0;
int isPause = 0;
int isWin = 0;
int isHelp = 0;
int isFullScreen = 0;

Carte tableJeu[LIGNE][COLONNE];

SDL_Surface *ecran = NULL, *background = NULL;

SDL_Surface *cardRecto = NULL, *cardVerso = NULL;

SDL_Surface *buttonPlay = NULL, *buttonQuit = NULL, *buttonQuit130 = NULL, *buttonRestart = NULL,
*buttonContinue = NULL, *buttonPause = NULL, *buttonHelp = NULL, *buttonCheck = NULL;

SDL_Surface *txtScore, *txtTimer, *txtWin, *txtHelp;

char timer[10] = "00:00";
char score[10] = "";

TTF_Font *police = NULL, *policeHelp = NULL;

SDL_Color couleurNoire = {30, 31, 32};



int nb_carteTire = 0;
int paireTrouve = 0;
int essai = 0;
int isFirstPick = 1;
int nbTick = 0;

Coord firstCard, secondCard;

#ifndef COMPUTER

int fileDescriptor;

void initTouch() {
    fileDescriptor = open("/dev/uinput", O_WRONLY | O_NONBLOCK);
    ioctl(fileDescriptor, UI_SET_EVBIT, EV_KEY);
    //ioctl(fileDescriptor, UI_SET_KEYBIT, BTN_RIGHT);
    //ioctl(fileDescriptor, UI_SET_KEYBIT, BTN_LEFT);
    ioctl(fileDescriptor, UI_SET_KEYBIT, BTN_TOUCH);
    ioctl(fileDescriptor, UI_SET_EVBIT, EV_ABS);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_X);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_Y);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_SLOT);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_TOUCH_MAJOR);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_TOUCH_MINOR);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_ORIENTATION);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_PRESSURE);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_POSITION_X);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_POSITION_Y);
    ioctl(fileDescriptor, UI_SET_ABSBIT, ABS_MT_TRACKING_ID);

    struct uinput_user_dev uidev;
    memset(&uidev, 0, sizeof(uidev));
    snprintf(uidev.name, UINPUT_MAX_NAME_SIZE, "EvitaTouch");
    uidev.id.bustype = BUS_USB;
    uidev.id.version = 0x110;
    uidev.id.vendor = 0x596;
    uidev.id.product = 0x506;

    uidev.absmin[ABS_X] = 0;
    uidev.absmax[ABS_X] = 32767;
    uidev.absfuzz[ABS_X] = 15;
    uidev.absflat[ABS_X] = 0;
    uidev.absmin[ABS_Y] = 0;
    uidev.absmax[ABS_Y] = 32767;
    uidev.absfuzz[ABS_Y] = 15;
    uidev.absflat[ABS_Y] = 0;

    uidev.absmin[ABS_MT_TOUCH_MAJOR] = 0;
    uidev.absmin[ABS_MT_TOUCH_MINOR] = 0;
    uidev.absmax[ABS_MT_TOUCH_MAJOR] = 32767;
    uidev.absmax[ABS_MT_TOUCH_MINOR] = 32767;
    uidev.absfuzz[ABS_MT_TOUCH_MAJOR] = 255;
    uidev.absfuzz[ABS_MT_TOUCH_MINOR] = 255;
    uidev.absmin[ABS_MT_ORIENTATION] = 0;
    uidev.absmax[ABS_MT_ORIENTATION] = 1;
    uidev.absmin[ABS_MT_POSITION_X] = 0;
    uidev.absmin[ABS_MT_POSITION_Y] = 0;
    uidev.absmax[ABS_MT_POSITION_X] = 32767;
    uidev.absmax[ABS_MT_POSITION_Y] = 32767;
    uidev.absfuzz[ABS_MT_POSITION_X] = 15;
    uidev.absfuzz[ABS_MT_POSITION_Y] = 15;
    uidev.absmax[ABS_MT_TRACKING_ID] = 65535;
    uidev.absmax[ABS_MT_SLOT] = 9;
    uidev.absmax[ABS_MT_PRESSURE] = 64;

    write(fileDescriptor, &uidev, sizeof(uidev));
    ioctl(fileDescriptor, UI_DEV_CREATE);

    usleep(100000);
}

int cptTouchTrackingId = 0;
void sendTouchPressed(int x, int y) {
    struct input_event ev;
    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_KEY;
    ev.code = BTN_TOUCH;
    ev.value = 1;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_SLOT;
    ev.value = 0;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_TRACKING_ID;
    ev.value = ++cptTouchTrackingId % 6400;
    //ev.value = 10;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_POSITION_X;
    ev.value = x * 32767.0 / (float)SCREEN_WIDTH;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_POSITION_Y;
    ev.value = y * 32767.0 / (float)SCREEN_HEIGHT;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_X;
    ev.value = x * 32767.0 / (float)SCREEN_WIDTH;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_Y;
    ev.value = y * 32767.0 / (float)SCREEN_HEIGHT;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_SYN;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    //usleep(2000);
}

void sendTouchDragged(int x, int y) {
    struct input_event ev;
    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_SLOT;
    ev.value = 0;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_POSITION_X;
    ev.value = x * 32767.0 / (float)SCREEN_WIDTH;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_POSITION_Y;
    ev.value = y * 32767.0 / (float)SCREEN_HEIGHT;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_X;
    ev.value = x * 32767.0 / (float)SCREEN_WIDTH;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_Y;
    ev.value = y * 32767.0 / (float)SCREEN_HEIGHT;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_SYN;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    //usleep(2000);
}

void sendTouchReleased() {
    struct input_event ev;
    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_SLOT;
    ev.value = 0;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_ABS;
    ev.code = ABS_MT_TRACKING_ID;
    ev.value = -1;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_KEY;
    ev.code = BTN_TOUCH;
    ev.value = 0;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    memset(&ev, 0, sizeof(struct input_event));
    ev.type = EV_SYN;
    write(fileDescriptor, &ev, sizeof(struct input_event));

    //usleep(2000);
}

void destroyTouch() {
    ioctl(fileDescriptor, UI_DEV_DESTROY);
    close(fileDescriptor);
}
#endif

void initJeu()
{
    

    /* Sauvegarde
        if (sauvegarde == exist)
    */
    int* tabAlea = NULL;
    tabAlea = tableauAleatoire(TABSIZE);
    unsigned int i,j,x = 0;
    for (i=0; i<LIGNE; i++)
    {
        for (j=0; j<COLONNE; j++)
        {

            tableJeu[i][j].position.x = j*170;
            tableJeu[i][j].position.y = i*180;
            
            tableJeu[i][j].face = VERSO;
            tableJeu[i][j].texture = tabAlea[x];


            #ifndef COMPUTER
            setTaxtTelRect(x+1, tableJeu[i][j].texture, tableJeu[i][j].position.x, tableJeu[i][j].position.y, tableJeu[i][j].position.x + 121, tableJeu[i][j].position.y+170);
            disableTaxTel(x+1);
            #endif
            x++;

        }
    }
    free(tabAlea);

}





void affichage()
{

    SDL_Rect position;
    position.x = 0;
    position.y = 0;

    SDL_BlitSurface(background, NULL, ecran, &position);

    if (isMenu)
    {
        #ifdef DEBUG
            printf(" affichage MENU\n");
        #endif
        position.y = 90;
        position.x = 340;
        SDL_BlitSurface(buttonPlay, NULL, ecran, &position);

        position.y = 320;
        SDL_BlitSurface(buttonQuit, NULL, ecran, &position);



    }
    else if(isHelp)
    {
        char titreHelp[] = "HELP";
        char welcome[] = "Welcome !";
        char helpFirst[] = "In this game, you'll have to find pairs of cards";
        char helpSecond[] = "Remember the tactictal feedback on the cards...";
        char helpSecondBis[] = "You have to localize them !";
        char helpThird[] = "Just select a card, touch and feel it !";

        char helpFourth[] = "Select any other card, touch and feel, it !";
        char helpFifth[] = "Press \"Check\" to compare them !";

            txtHelp = TTF_RenderText_Blended(policeHelp, titreHelp, couleurNoire);
            position.x = 435;
            position.y = 5;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, welcome, couleurNoire);
            position.x = 15;
            position.y = 50;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, helpFirst, couleurNoire);
            position.y = position.y + 65;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, helpSecond, couleurNoire);
            position.y = position.y + 65;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, helpSecondBis, couleurNoire);
            position.y = position.y + 65;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, helpThird, couleurNoire);
            position.y = position.y + 65;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, helpFourth, couleurNoire);
            position.y = position.y + 65;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            txtHelp = TTF_RenderText_Blended(policeHelp, helpFifth, couleurNoire);
            position.y = position.y + 65;
            SDL_BlitSurface(txtHelp, NULL, ecran, &position);

            position.x = 690 ;
            position.y = position.y+20; 
            SDL_BlitSurface(buttonContinue, NULL, ecran, &position);
    }
    else
    {
        unsigned int i,j, x=0;
    	for (i=0; i<LIGNE; i++)
    	{
    		for (j=0; j<COLONNE;j++)
    		{
                switch (tableJeu[i][j].face)
                {
                    case RECTO:
                        SDL_BlitSurface(cardRecto, NULL, ecran, &tableJeu[i][j].position);
                        //enableTaxTel(x+1);
                        break;

                    case VERSO:

                        SDL_BlitSurface(cardVerso, NULL, ecran, &tableJeu[i][j].position);
                        //disableTaxTel(x+1);
                        break;

                    default:
                        //disableTaxTel(x+1);
                        #ifdef DEBUG
                            printf("Moins 1\n");
                        #endif
                            break;
                }
                x++;
    		}
    	}
        #ifdef DEBUG
            printf("Affichage Done\n");
        #endif
        if (isPause)
        {
            position.x = 340;
            position.y = 70;
            SDL_BlitSurface(buttonContinue, NULL, ecran, &position);
            position.y = 220;
            SDL_BlitSurface(buttonHelp, NULL, ecran, &position);
            position.y = 390;
            SDL_BlitSurface(buttonQuit130, NULL, ecran, &position);
        }
        position.y = 538;
        position.x = 22;
        SDL_BlitSurface(buttonPause, NULL, ecran, &position);
        position.x = 840;
        SDL_BlitSurface(buttonCheck, NULL, ecran, &position);
        sprintf(score, "%d", essai);    

        txtScore = TTF_RenderText_Solid(police, score, couleurNoire);
        position.x = 466;
        position.y = 538;
        SDL_BlitSurface(txtScore, NULL, ecran, &position);
/*
        txtTimer = TTF_RenderText_Solid(police, timer, couleurNoire);
        position.x = 800;
        SDL_BlitSurface(txtTimer, NULL, ecran, &position);
        */
        if(isWin)
        {
            char win[30] = "Congratulations !!!";
            txtWin = TTF_RenderText_Blended(police, win, couleurNoire);
            position.x = 270;
            position.y = 70;
            SDL_BlitSurface(txtWin, NULL, ecran, &position);
            position.x = 410;
            position.y = 200;
            txtTimer = TTF_RenderText_Solid(police, timer, couleurNoire);
            SDL_BlitSurface(txtTimer, NULL, ecran, &position);
            position.x = 200;
            position.y = 320;
            SDL_BlitSurface(buttonRestart, NULL, ecran, &position);
            position.x = 500;
            SDL_BlitSurface(buttonQuit130, NULL, ecran, &position);

        }
        
    }
	SDL_Flip(ecran);
}

 
void actionListener()
{
    SDL_Event event;
    SDL_Rect controlEvent;
    int isPressed = 0;
    #ifdef DEBUG
        printf("actionListener\n");
    #endif
    int continuer = 1;
    while (continuer)
    {
        #ifdef DEBUG
           // printf("wait touch\n");
        #endif
        SDL_WaitEvent(&event);

            if (event.type == SDL_QUIT || (event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE))//switch(event.type || isPressed)
            {
                //case SDL_QUIT:
                    continuer = 0;
                    //break;
            }
            if (!((event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_SPACE)|| 
                (event.type == SDL_MOUSEBUTTONDOWN && event.button.button == SDL_BUTTON_LEFT)))
            {
                continue;
            }
            if (event.type==SDL_KEYDOWN && event.key.keysym.sym == SDLK_SPACE) //FULLSCREEN
            {
                if (isFullScreen)
                {
                   ecran = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, 32, SDL_HWSURFACE);
                    isFullScreen = 0;
                }
                else
                {
                   ecran = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, 32, SDL_FULLSCREEN);
                   isFullScreen = 1; // Ouverture de la fenêtre
                }
            }
            if (event.type == SDL_MOUSEBUTTONDOWN || isPressed)
            {
                //case (SDL_MOUSEBUTTONUP || isPressed):
                    if(event.button.button == SDL_BUTTON_LEFT)
                    {
                        controlEvent.x = event.button.x;
                        controlEvent.y = event.button.y;
                        #ifdef DEBUG   
                            printf("Hauteur: %d, Largeur: %d\n", controlEvent.y, controlEvent.x);
                        #endif
                    }
                    if (isPressed)
                    {
                        #ifndef COMPUTER
                            controlEvent.x = getX();
                            controlEvent.y = getY();
                        #endif
                        #ifdef DEBUG
                            printf("Get Pressed X: %d, Y: %d\n", controlEvent.x, controlEvent.y);
                        #endif
                    }    
                        if (isMenu)
                        {
                            //JOUER OU QUITTER
                            if (controlEvent.x > 380 && controlEvent.x <661)
                            {
                                if(controlEvent.y > 90 && controlEvent.y < 290 )
                                {
                                    //BUTTON PLAY
                                    isMenu = 0;
                                    initJeu();
                                    #ifdef DEBUG
                                        printf("action listener MENUs\n");
                                    #endif

                                    //affichage();
                                }

                                if(controlEvent.y > 320 && controlEvent.y < 520)
                                {
                                    continuer = 0;
                                }
                                
                            }
                            //affichage();
                        }
                        else if(isHelp)
                        {
                            //MENU AIDE
                            if(controlEvent.y > 460 && controlEvent.x > 690)
                            {
                                //BUTTON CONTINUE
                                isHelp = 0;
                            }
                        }
                        else if (isPause)
                        {
                                    if (controlEvent.x > 340 && controlEvent.x < 637)
                                    {
                                        if (controlEvent.y > 70 && controlEvent.y < 200)
                                        {
                                            //BUTTON CONTINUER
                                            isPause = 0;
                                            //affichage();
                                        }
                                        if (controlEvent.y > 220 && controlEvent.y < 350)
                                        {
                                            //BUTTON HELP
                                            isHelp = 1;
                                        }
                                        if (controlEvent.y > 390 && controlEvent.y < 520)
                                        {
                                            //BUTTON QUIT
                                            continuer = 0;
                                        }
                                    }
                            //affichage();
                        }
                        else if (isWin)
                        {
                            /*  position.x = 200;
                                position.y = 320;   297*130
                                SDL_BlitSurface(buttonContinue, NULL, ecran, &position);
                                position.x = 500;
                                SDL_BlitSurface(buttonQuit130, NULL, ecran, &position);
                            */
                            if (controlEvent.y > 320 && controlEvent.y < 450)
                            {
                                if(controlEvent.x > 200 && controlEvent.x < 497)
                                {
                                    #ifdef DEBUG
                                        printf("Button Continue\n");

                                    #endif
                                    nbTick = 0;
                                    isMenu = 0;
                                    isWin = 0;
                                    nb_carteTire = 0;
                                    essai = 0;
                                    initJeu();
                                }
                                if(controlEvent.x > 500 && controlEvent.x < 797)
                                {
                                    #ifdef DEBUG
                                        printf("QUIT\n");
                                    #endif
                                    continuer = 0;
                                }
                            }
                        }
                        else
                        {
                            // EN PARTIE
                            if (controlEvent.y < 530)
                            {
                                #ifdef DEBUG
                                    printf("ZONE DE CARTE \n");
                                #endif
                                            switch (nb_carteTire)
                                            {

                                                Coord *card = NULL;
                                                case 0: 
                                                    //premiereCarte(controlEvent);
                                                    if (firstCard.colonne == -1 && firstCard.ligne == -1)
                                                    {
                                                        card = localisation(controlEvent);

                                                        firstCard.ligne = card->ligne;
                                                        firstCard.colonne = card->colonne;
                                                        switchCarte(firstCard.ligne, firstCard.colonne);
                                                        nb_carteTire++; 
                                                    }
                                                    //affichage();
                                                    /*
                                                        Affecter la carte à paire
                                                        switch de la carte
                                                        nb_tire++
                                                        affichage

                                                    */                                                    break;

                                                case 1: 
                                                    if (secondCard.colonne == -1 && secondCard.ligne == -1)
                                                    { 
                                                        card = localisation(controlEvent);
                                                        printf("2eme carte %d - firstCard %d\n", card->colonne, firstCard.colonne);
                                                        if(card->colonne != firstCard.colonne || card->ligne != firstCard.ligne)
                                                        {

                                                            printf("Pas la meme\n");
                                                            //Card n'est pas firstcard
                                                            secondCard.colonne = card->colonne;
                                                            secondCard.ligne = card->ligne;
                                                            
                                                            switchCarte(secondCard.ligne, secondCard.colonne);

                                                            nb_carteTire++;
                                                        }
                                                        
                                                    }
                                                    //affichage();

                                                    /*
                                                        Affecter carte a paire
                                                        switch  de la carte
                                                        nb_tire++
                                                        affichage
                                                    */
                                                default:
                                                   
                                                    break;

                                                        free(card);

                                            }
                            //affichage();
                            }
                            else
                            {
                                //BARRE D'ACTION
                                if(controlEvent.x < 148 && controlEvent.x > 22)
                                {
                                    //BUTTON PAUSE
                                    isPause = 1;
                                    //affichage();
                                }

                                if (controlEvent.x > 840 && controlEvent.x < 966)
                                {
                                    if(nb_carteTire == 2)
                                    {
                                        checkPaire();
                                        nb_carteTire = 0;
                                    }
                                }
                                //affichage();
                            }
                        }
                     //   break;
            } 

        affichage();    
    }
}

void switchCarte(int i, int j)
{
    #ifdef DEBUG
        printf("ça switch en i: %d, et j: %d\n", i, j);
    #endif
    if (i != -1 && j!= -1)
    {
        if (tableJeu[i][j].face == VERSO)
        {
                tableJeu[i][j].face = RECTO;
                #ifndef COMPUTER
                    enableTaxTel(i*6+j+1);
                #endif
                    #ifdef DEBUG
                        printf("VERSO -> RECTO\n");
                    #endif
        }
        else if (tableJeu[i][j].face == RECTO)
        {
            if (nb_carteTire >= 2)
            {
                tableJeu[i][j].face = VERSO;
            }     
        }   
    }
}



Coord* localisation(SDL_Rect event)
{
    Coord *carte = malloc(sizeof(Coord));
    carte->colonne = event.x / 170;
    carte->ligne =  event.y / 180;
    #ifdef DEBUG
        printf("colonne: %d, ligne: %d\n motif:%d\n", carte->colonne, carte->ligne, tableJeu[carte->ligne][carte->colonne].texture);
    #endif
    return carte;
}


int paireBonne()
{
    printf("ligne %d colonne %d ligne %d colonne %d\n",firstCard.ligne, firstCard.colonne, secondCard.ligne, secondCard.colonne );
    if (firstCard.colonne != -1 && firstCard.ligne != -1 && secondCard.ligne != -1 && secondCard.colonne != -1)
    {
        if ((tableJeu[firstCard.ligne][firstCard.colonne].texture == tableJeu[secondCard.ligne][secondCard.colonne].texture)
            && (firstCard.ligne != secondCard.ligne || firstCard.colonne != secondCard.colonne))
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
    else
    {
        #ifdef DEBUG
            printf("Valeur == -1\n");
        #endif
    }
    return 0;
}

int randAB(int a, int b)
{
    return rand()%(b-a) + a;
}

int* tableauAleatoire(int size)
{
    int* tab = malloc((size)*sizeof(int));
    int i, temp, x = 1; 
    for (i=1; i < 18 ;i= i+2)
    {
        tab[i-1] = x;
        tab[i] = x;
        x++;
    }

    for(i = 0; i < 18; i++)
    {
        int nb_tire = randAB(1,18);
        temp = tab[i];
        tab[i] = tab[nb_tire];
        tab[nb_tire] = temp;

    }
    for(i = 0; i< 18; i++)
    {
        printf("| %d ", tab[i]);
        if (i+1 / 6 != 0 && (i+1) % 6 == 0)
            printf("|\n");
    }
    return tab;
}


void checkPaire()
{
    #ifdef DEBUG
        printf("Debut checkPaire\n");
    #endif
    if(paireBonne())
    {
        #ifdef DEBUG
            printf("Paire Bonne Trouvé");
        #endif
        tableJeu[firstCard.ligne][firstCard.colonne].face = OUT;
        tableJeu[secondCard.ligne][secondCard.colonne].face = OUT;

        paireTrouve++;
        if (paireTrouve >= 9)isWin = 1;
        
    }
    else
    {
         #ifdef DEBUG
            printf("Mauvaise Paire\n");
        #endif

        tableJeu[firstCard.ligne][firstCard.colonne].face = VERSO;
        tableJeu[secondCard.ligne][secondCard.colonne].face = VERSO;
       
    }

    #ifndef COMPUTER
        // Désactivation des zone de texture
        disableTaxTel(6*(firstCard.ligne) + firstCard.colonne + 1);
        disableTaxTel(6*(secondCard.ligne) + secondCard.colonne + 1);
    #endif
        //initialisation des variable firstCard et secondCard
        //Pret à un nouvel essai
    firstCard.ligne = -1;
    firstCard.colonne = -1;
    secondCard.ligne = -1;
    secondCard.colonne = -1;
    essai++;
}


Uint32 ajouterSeconde(Uint32 intervalle, void* param)
{
    if (isMenu || isPause || isWin || isHelp)
    {

    }
    else
    {  
        int* tick = param;
        (*tick)++;
        compteTick(*tick);
        //affichage();
    }
    
    return intervalle;

}

void compteTick(int nbTick)
{

    int minute = nbTick / 60;
    int seconde = nbTick % 60;
    char sMinute[10];
    char sSeconde[10];
    sprintf(sMinute, "%.2d:", minute);
    sprintf(sSeconde, "%.2d", seconde);
    strcpy(timer, sMinute);
    strcat(timer, sSeconde);

}



int main(int argc, char *argv[])
{
   

    //int nbTick = 0;
/////////////////////INITIALISATION DES L

    SDL_TimerID timerT; 
    SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER); // Initialisation de la SDL
    TTF_Init();
    srand(time(NULL));
 
    ecran = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, 32, SDL_HWSURFACE); // Ouverture de la fenêtre
    SDL_WM_SetCaption("Memory", NULL);
    SDL_WM_SetIcon(IMG_Load("./Images/Size/icon.png"), NULL);
    

    background = IMG_Load("./Images/Size/tapis_billard_1000_600.jpeg");
    
    buttonPlay = IMG_Load("./Images/Size/buttonPlay200px.png");
    buttonQuit = IMG_Load("./Images/Size/buttonQuit200px.png");
    buttonContinue = IMG_Load("./Images/Size/buttonContinue130px.png");
    buttonPause = IMG_Load("./Images/Size/buttonPause55px.png");
    buttonHelp = IMG_Load("./Images/Size/buttonHelp130px.png");
    buttonQuit130 = IMG_Load("./Images/Size/buttonQuit130px.png");
    buttonCheck = IMG_Load("./Images/Size/buttonCheck55px.png");
    buttonRestart = IMG_Load("./Images/Size/buttonRestart130px.png");

    cardRecto = IMG_Load("./Images/Size/carteRecto170px.png");
    cardVerso = IMG_Load("./Images/Size/carteVerso170px.png");


    
    
    police = TTF_OpenFont("saintpeter.ttf", 65);
    policeHelp = TTF_OpenFont("saintpeter.ttf", 50);


    if (ecran == NULL)
    {
        fprintf(stderr, "Impossible de charger le mode vidéo : %s\n", SDL_GetError());
        exit(EXIT_FAILURE);
    }

    #ifndef COMPUTER
        initTouch();
        registerCallbackPressed(sendTouchPressed);
        registerCallbackDragged(sendTouchDragged);
        registerCallbackRelease(sendTouchReleased);


    startEvita();

        setTextureRect(1,50,45,800,0.5,"diagonal");
        setTextureRect(2,30,35,4050,0.1,"diagonal");
        setTextureRect(3,50,45,1200,0.1,"diagonal");
        setTextureRect(4,40,30,6000,0.5,"diagonal");
        setTextureRect(5,60,30,6000,0.5,"diagonal");
        setTextureRect(6,60,30,800,0.1,"diagonal");
        setTextureRect(7,60,30,8000,0.9,"diagonal");
        setTextureRect(8,70,25,5000,0.6,"diagonal");
        setTextureRect(9,60,30,9400,0.5,"diagonal");

    #endif
    
    firstCard.colonne = -1;
    firstCard.ligne = -1;
    secondCard.colonne = -1;
    secondCard.ligne = -1;
    // MENU DU JEU
    isMenu = 1;

    timerT = SDL_AddTimer(1000, ajouterSeconde, &nbTick);
    affichage();
    actionListener();


    //JOUER



    //QUITTER

    SDL_RemoveTimer(timerT);
    #ifndef COMPUTER
    destroyTouch();
        stopEvita();
    #endif
    SDL_FreeSurface(background);
    SDL_FreeSurface(cardVerso);
    SDL_FreeSurface(cardRecto);
    SDL_FreeSurface(buttonPause);
    SDL_FreeSurface(buttonQuit);
    SDL_FreeSurface(buttonContinue);
    SDL_FreeSurface(buttonPlay);
    SDL_FreeSurface(buttonQuit130);
    SDL_FreeSurface(buttonCheck);
    SDL_FreeSurface(buttonHelp);
    SDL_FreeSurface(buttonRestart);
    TTF_CloseFont(police);
    TTF_CloseFont(policeHelp);
    TTF_Quit();
    SDL_Quit(); // Arrêt de la SDL
 
    return EXIT_SUCCESS; // Fermeture du programme
}
