/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    1 tab == 2 spaces!
*/





#include <stdlib.h>
#include <string.h>
#include <util/delay.h>
#include <arduino.h>
#ifdef GCC_MEGA_AVR
	/* EEPROM routines used only with the WinAVR compiler. */
	#include <avr/eeprom.h>
#endif

/* Scheduler include files. */
#include "Arduino_FreeRTOS.h"
#include "task.h"
#include "croutine.h"
#include "serial.h"


int setup(void);
void loop(void);


/*-----------------------------------------------------------*/

int main( void )
{
  
  setup();
  while(1){
    loop();
  }
	return 0;
}
/*-----------------------------------------------------------*/



/************************************************************

   Here start the user program

************************************************************/
#include "main.h"


/* Headers for eth and Lora */
#include "SPI.h"
#include "enc28j60.h"

#define ETH_RCPT	18
#define ETH_SEND	16

#define MAX_BOUTONS     2

// Eth
unsigned char mac[]={0x00,0x10,0x10,0x10,0x10,0x10};
unsigned char broadcast[]={0xff,0xff,0xff,0xff,0xff,0xff};
unsigned char type[]={0x11,0x11};

// Multi Thread control
SemaphoreHandle_t spiMutex = NULL;

xComPortHandle serial;  // Gloable serial

unsigned char laststate[MAX_BOUTONS];

int setup(){
  DDRC &= ~0x03;//init the ports
  PORTC |= 0x03;
  DDRD |= 0xfc;
  PORTD &= ~0xfc;

  // init buttons
  for(int i=0;i<MAX_BOUTONS;i++) laststate[i]=1;
  
  //serial
  serial = xSerialPortInitMinimal( 9600, 16 );  //Baud and max length of PutString

  // SPI
  spi_init();
  
  // Sémaphore
  spiMutex = xSemaphoreCreateMutex( );

  // Eth
  enc28j60IOSetup();
  enc28j60Init(mac);  // May be error

  // Tasks to be run  
  xTaskCreate( vTaskLED1 , "T1", configMINIMAL_STACK_SIZE, NULL, 1, NULL );
  xTaskCreate( vTaskLED2 , "T2", configMINIMAL_STACK_SIZE, NULL, 1, NULL );
  xTaskCreate( vTaskSerial, "T3", configMINIMAL_STACK_SIZE, NULL, 1, NULL );
  xTaskCreate( vTaskEthReadData, "T4", configMINIMAL_STACK_SIZE, NULL, 1, NULL );
  xTaskCreate( vTaskEthSendData, "T5", configMINIMAL_STACK_SIZE, NULL, 1, NULL );
  
  // Start the FreeRTOS
  vTaskStartScheduler();
  
  return 0;
  
}


void loop(){
  // If FreeRTOS is used do no thing here.
  
}


void vTaskEthReadData(void* pvParameters){
  (void)pvParameters;
  int nb_ethernet = 0;
  unsigned char packetReceived[ETH_RCPT];
  TickType_t xTicksToWait = 10;
    
  while(1){ 
    while( xSemaphoreTake( spiMutex, xTicksToWait ) != pdTRUE ){  }
    nb_ethernet = enc28j60PacketReceive(); //Cheack if there is data in eth device
    xSemaphoreGive( spiMutex );
    if(nb_ethernet==0){
	vTaskDelay( 5 / portTICK_PERIOD_MS );
	continue;
    }
    if(nb_ethernet==64){
	int i;
	for(i=0;i<ETH_RCPT;i++){	
          while( xSemaphoreTake( spiMutex, xTicksToWait ) != pdTRUE ){  }
	  packetReceived[i] = enc28j60ByteRead();
          xSemaphoreGive( spiMutex );
	  }
	
	/* Test sur l'adresse Ethernet source (fait par chip ENC28j60) */
	
	if(packetReceived[13]==type[0] && packetReceived[12]==type[1]){/* Test sur le type de paquet Ethernet */
		if(packetReceived[14]!=0) PORTD |= (1<<5); else PORTD &= ~(1<<5);
		if(packetReceived[15]!=0) PORTD |= (1<<6); else PORTD &= ~(1<<6); 
		if(packetReceived[16]!=0) PORTD |= (1<<7); else PORTD &= ~(1<<7);
		}	
	}
	
    while( xSemaphoreTake( spiMutex, xTicksToWait ) != pdTRUE ){  }
    enc28j60FreeMemory();
    xSemaphoreGive( spiMutex );
    }
}

#define bouton(num) (((PINC & (1<<num))==0)?0:1)

int bouton_com(int num){
   int state=bouton(num);
   if(state!=laststate[num]){
     laststate[num]=state;
     return 1;
     }
   else return 0;
}

void vTaskEthSendData( void * pvParameters ){
  (void)pvParameters;
  unsigned char packetToSend[ETH_SEND]; 
  TickType_t xTicksToWait = 10;
  for( ;; ){
    if(bouton_com(0) || bouton_com(1)){
       PORTD ^= (1<<4);
       while( xSemaphoreTake( spiMutex, xTicksToWait ) != pdTRUE ){  }
       enc28j60InitializeSend(); 
       xSemaphoreGive( spiMutex );
       int size=0;
       memcpy(packetToSend+size,broadcast,sizeof(broadcast));
       size += sizeof(broadcast);
       memcpy(packetToSend+size,mac,sizeof(mac));
       size += sizeof(mac);
       memcpy(packetToSend+size,type,sizeof(type));
       size += sizeof(type);
       memcpy(packetToSend+size,laststate,sizeof(laststate));
       for(int j=0;j<ETH_SEND;j++) {
            while( xSemaphoreTake( spiMutex, xTicksToWait ) != pdTRUE ){  }
            enc28j60WriteByteSend(packetToSend[j]);
            xSemaphoreGive( spiMutex );
          }
       while( xSemaphoreTake( spiMutex, xTicksToWait ) != pdTRUE ){  }
       enc28j60FinalizeSend();
       xSemaphoreGive( spiMutex );
       PORTD ^= (1<<4);
       }		
      }      
        
   vTaskDelay( 50 / portTICK_PERIOD_MS );
}



#if 0

void vTaskSerialReadData( void * pvParameters ){
  struct Message* ptrMessage = NULL;
  TickType_t xTicksToWait = 10;
  char* buff = (char*)malloc(sizeof(char)*MAX_FRAGMENT);
  char c = 0x00;
  for(;;){
    int i;
    for(i = 0; i < MAX_FRAGMENT; i ++){
      if(xSerialGetChar( serial, &c, xTicksToWait )!=pdTRUE){
        break;
      }
    }
    if(i == 0){
      continue;
    }
    int size = i + 1;
    ptrMessage = (struct Message*)malloc(sizeof(struct Message));
    if(ptrMessage == NULL){
      continue;
    }
    
    char *ptrPacketReceived = (char*)malloc(sizeof(char)*size);
    if(ptrPacketReceived == NULL){
      free(ptrPacketReceived);
      continue;
    }   
    
    for(i = 0;i < size; i++){
      ptrPacketReceived[i] = buff[i];
    }
    
    ptrMessage->size = size;
    ptrMessage->message = ptrPacketReceived;    
    while(xQueueSend(ethReadQueue, ptrMessage, xTicksToWait) != pdTRUE){}
  }
  free(buff);
}


#endif

void vTaskLED1( void * pvParameters ){
  (void)pvParameters;
  for( ;; )
  {
    //delay(1000);
    vTaskDelay( 1000 / portTICK_PERIOD_MS );
    PORTD ^= (1<<2);
  }
}

void vTaskLED2( void * pvParameters ){
  (void)pvParameters;
  for( ;; )
  {
    //delay(500);
    vTaskDelay( 500 / portTICK_PERIOD_MS );
    PORTD ^= (1<<3);
  }
}


void vTaskSerial( void * pvParameters ){
  (void)pvParameters;
  for( ;; )
  {
    //delay(250);
    char* message = "Hello world\n\r";
    vTaskDelay( 250 / portTICK_PERIOD_MS );
    vSerialPutString( serial, (const signed char *)message, strlen( message ));
  }
}

#if 0

void vTaskCodeCalc( void * pvParameters ){
  int something = 0;
  for( ;; )
  {
    something++;
  }
}
#endif







