#include <ESP8266WiFi.h>
#include <WiFiClient.h> 
#include <Ticker.h>

Ticker timer;

#define   PmotG   5
#define   PmotD   0
#define   Prot1G  14
#define   Prot2G  13
#define   Prot1D  16
#define   Prot2D  12
#define   PIR     15


int IRcount=0;
int pwmCount=0;
int pwmCmpG=0;
int pwmCmpD=0;
bool IRState=false;


const char *ssid = "robot_tete";
const char *password = "manumau";

WiFiServer server(80);

void wifiSetup()
{
  Serial.println();
  Serial.print("Configuring access point...");
  WiFi.mode(WIFI_AP);
  WiFi.softAP(ssid);

  IPAddress myIP = WiFi.softAPIP();
  Serial.print("AP IP address: ");
  Serial.println(myIP);
  Serial.print("SSID: ");
  Serial.println(ssid);
  server.begin();
  Serial.println("HTTP server started");
}

void hardwareSetup()
{
  pinMode(PmotG,OUTPUT);
  pinMode(PmotD,OUTPUT);
  pinMode(Prot1G,OUTPUT);
  pinMode(Prot2G,OUTPUT);
  pinMode(Prot1D,OUTPUT);
  pinMode(Prot2D,OUTPUT);
  pinMode(PIR,OUTPUT); 

  digitalWrite(PmotG,LOW);
  digitalWrite(PmotD,LOW);
  digitalWrite(Prot1G,HIGH);
  digitalWrite(Prot1D,LOW);
  digitalWrite(Prot2G,HIGH);
  digitalWrite(Prot1D,LOW);
  digitalWrite(PIR,LOW);
}


/*Getion de la PWM et de l'emission IR*/
void ISR()
{
  pwmCount++;
  if(pwmCount>20)
    pwmCount=0;
  if(pwmCount<pwmCmpG)
    digitalWrite(PmotG,HIGH);
  else
    digitalWrite(PmotG,LOW);
  if(pwmCount<pwmCmpD)
    digitalWrite(PmotD,HIGH);
  else
    digitalWrite(PmotD,LOW);

  IRcount++;
  if(IRcount==13)
    IRcount=0;
  if(IRcount==0)
    digitalWrite(PIR,HIGH);
  else if (IRcount==1)
    digitalWrite(PIR,LOW);
}

void checkForClients()
{
  WiFiClient client = server.available();
  if (!client)
    {return;}
    
  Serial.println("\t connecté !");
  
  String rep="HTTP/1.1 200 OK\r\nContent-type: text/html\r\n\r\n";
  
  String req = client.readStringUntil('\ ');
  Serial.print("req:");
  Serial.println(req);
    
  if(!req.equals(""))
  {
    String page = client.readStringUntil('\ ');
    Serial.print("Page:");
    Serial.println(page);
    
    if(page.equals("/interface"))
    {
      rep+="<DOCTYPE HTML>\
      <html>  \
        <head>\
          <meta charset='utf-8\' />\
          <title>Interface de contrôle du robot de tête</title>\
      </head>\
      <body>\
          <h2>Interface de contrôle du robot de tête</h2>\
      <p>\
        Donner la direction du robot: \
      </p>\
      <input type='button' name='Gauche' value='Gauche [Q]' onclick=\"self.location.href='bouger?ordre=LEF'\" \
       style='color:black; font-weight:bold' >\
      <input type='button' name='Tout droit' value='Tout droit [Z]' onclick=\"self.location.href='bouger?ordre=FOR'\" \
       style='color:black; font-weight:bold'>\
      <input type='button' name='Droite' value='Droite [D]' onclick=\"self.location.href='bouger?ordre=RIG'\" \
       style='color:black; font-weight:bold'>\
      <input type='button' name='Stop' value='Stop [S]' onclick=\"self.location.href='bouger?ordre=STB'\" \
       style='color:black; font-weight:bold'>\
        </body> \
    </html>\        
          <script> \
          { \
            window.onkeydown=function checkKey(e)\
            {\
              switch(e.keyCode)\
              {\
                case 90:  \
                  window.location.href = 'bouger?ordre=FOR'; \
                break;\
                case 81:  \
                  window.location.href = 'bouger?ordre=LEF'; \
                break;  \
                case 83:   \
                  window.location.href = 'bouger?ordre=STB';  \
                break;  \
                case 68:  \
                  window.location.href = 'bouger?ordre=RIG';  \
                break;  \
                default:\
                  window.location.href = 'bouger?ordre=STB';  \
                break;\
              } \
            } \
          }\
            </script> ";
    }

    else if(page.lastIndexOf("bouger?")>=0)
    {
      if(page.lastIndexOf("FOR")>0)
      {
        pwmCmpG=15;
        pwmCmpD=15;
        delay(50);
        pwmCmpG=7;
        pwmCmpD=7;
        digitalWrite(Prot1G,LOW);
        digitalWrite(Prot2G,HIGH);
        digitalWrite(Prot1D,HIGH);
        digitalWrite(Prot2D,LOW);
      }
      else if(page.lastIndexOf("LEF")>0)
      {
        pwmCmpG=10;
        pwmCmpD=15;
        delay(50);
        pwmCmpG=5;
        pwmCmpD=8;
        digitalWrite(Prot1G,LOW);
        digitalWrite(Prot2G,HIGH);
        digitalWrite(Prot1D,HIGH);
        digitalWrite(Prot2D,LOW);
      }
      else if(page.lastIndexOf("RIG")>0)
      {
        pwmCmpG=15;
        pwmCmpD=10;
        delay(50);
        pwmCmpG=8;
        pwmCmpD=5;
        digitalWrite(Prot1G,LOW);
        digitalWrite(Prot2G,HIGH);
        digitalWrite(Prot1D,HIGH);
        digitalWrite(Prot2D,LOW);
      }
      else
      {
        pwmCmpG=0;
        pwmCmpD=0;
      }
      
      rep+="<DOCTYPE HTML>\r\n \
      <html>\r\n \
      Bouger !\r\n   \
      <meta http-equiv='refresh' content='0; URL=interface'>\
      <html>";
      
    }
  }
  else
    {
      Serial.println("Req vide");
    }

 
  client.print(rep);
  //Serial.println(millis());

  client.flush();
  while(client.available())
    client.read();

  client.stop();
  
  delay(50);
}



void setup() 
{
	delay(1000);
	Serial.begin(9600);
  wifiSetup();
  hardwareSetup();
  timer.attach_ms(1,ISR);
}


void loop() 
{
  checkForClients();
}






