var log = function(text) {
  var li = document.createElement('li');
  li.innerHTML = text;
  document.getElementById('log').appendChild(li);
}

var socket = new WebSocket('ws://192.168.43.3:8081/');
socket.onopen = function(event) {
  log('Opened connection 🎉');
  var json = JSON.stringify({ message: 'Hello' });
  socket.send(json);
  log('Sent: ' + json);
}

socket.onerror = function(event) {
  log('Error: ' + JSON.stringify(event));
}

socket.onmessage = function (event) {
  log('Received: ' + event.data);
}

socket.onclose = function(event) {
  log('Closed connection 😱');
}

document.querySelector('#close').addEventListener('click', function(event) {
  socket.close();
  log('Closed connection 😱');
});

document.querySelector('#send').addEventListener('click', function(event) {
  var json = JSON.stringify({ message: 'Hey there' });
  socket.send(json);
  log('Sent: ' + json);
});


window.addEventListener('beforeunload', function() {
  socket.close();
});


define(function (require) {
   var mynipple = require("./nipplejs");
   //mynipple.create(options);

//Test
var s = function(sel) { return document.querySelector(sel);};
var sId = function(sel) { return document.getElementById(sel);};
var maxValue = 500;
var size = 100;

var options = {
  zone: document.getElementById('static'),
  mode: 'static',
  position: {left: '50%', top: '50%'},
  color: 'blue',
  restJoystick: true,
  size: size
};
var joystick;

var els = {
  position: {
    x: sId('xVal'),
    y: sId('yVal')
  },
  frontPosition: {
    frontx: sId('dist'),
    fronty: sId('angle')
  }
};

var timeoutCreate;
function createThrottle (evt) {
  clearTimeout(timeoutCreate);
  timeoutCreate = setTimeout(() => {
    createNipple(evt);
  }, 100);
}

function bindNipple() {
  joystick.on('start end', function(evt, data) {
    sId('xVal').innerHTML = '+000';
    sId('yVal').innerHTML = '+000';
    sId('dist').innerHTML = 0;
    sId('angle').innerHTML = 0;

    if($('#xVal').text()!="" && $('#yVal').text()!=""){
      var json = "X" + $('#xVal').text() + "Y" + $('#yVal').text();
      socket.send(json);
    }

  }).on('move', function(evt, data) {
    var x = Math.trunc(2*data['distance']*Math.cos(data['angle']['radian'])*maxValue/size);
    var y = Math.trunc(2*data['distance']*Math.sin(data['angle']['radian'])*maxValue/size);

    var xTemp = Math.abs(x);
    var yTemp = Math.abs(y);

    if(x >= 0)
      x = '+';
    else
      x = '-';

    if(xTemp >= 0 && xTemp < 10)
      x += '00' + xTemp;
    else if(xTemp >= 10 && xTemp < 100)
      x += '0' + xTemp;
    else if(xTemp >= 100 && xTemp <=500)
      x += xTemp;

    if(y >= 0)
      y = '+';
    else
      y = '-';

    if(yTemp >= 0 && yTemp < 10)
      y += '00' + yTemp;
    else if(yTemp >= 10 && yTemp < 100)
      y += '0' + yTemp;
    else if(yTemp >= 100 && yTemp <=500)
      y += yTemp;

    sId('xVal').innerHTML = x;
    sId('yVal').innerHTML = y;
    
    sId('dist').innerHTML = data['distance'];
    sId('angle').innerHTML = data['angle']['degree'];
    //debug(data);

    if($('#xVal').text()!="" && $('#yVal').text()!=""){
      var json = "X" + $('#xVal').text() + "Y" + $('#yVal').text();
      socket.send(json);
    }
  });
}

function createNipple() {
  if (joystick) {
    joystick.destroy();
  }
  joystick = mynipple.create(options);
  bindNipple();
}

createNipple();

// Print data into elements
function debug(obj) {
  function parseObj(sub, el) {
    for (var i in sub) {
      if (typeof sub[i] === 'object' && el) {
        parseObj(sub[i], el[i]);
      } else if (el && el[i]) {
        el[i].innerHTML = sub[i];
      }
    }
  }
  setTimeout(function() {
    parseObj(obj, els);
  }, 0);
}


});
