    #include <stdio.h>   /* Standard input/output definitions */
    #include <string.h>  /* String function definitions */
    #include <unistd.h>  /* UNIX standard function definitions */
    #include <fcntl.h>   /* File control definitions */
    #include <errno.h>   /* Error number definitions */
    #include <termios.h> /* POSIX terminal control definitions */
	#include <signal.h>

	int fd;
	FILE* fcom; //pointeur vers le stockage des commandes vers le robot
    FILE* fcap; //pointeur vers le stockage des valeurs des capteurs
    

    void intHandler(int dummy) {
    	//if(fcap!=NULL)fclose(fcap); //potentiel crash problem
    	fclose(fcom);
      	close(fd);
      	exit(0);
	}

    /*
     * 'open_port()' - Open serial port 1.
     *
     * Returns the file descriptor on success or -1 on error.
     */

    int
    open_port(void)
    {
      int fd; /* File descriptor for the port */


      fd = open("/dev/ttyACM0", O_RDWR | O_NOCTTY | O_NDELAY);
      if (fd == -1)
      {
       /*
        * Could not open the port.
        */
        printf("Erreur port non ouvrable\n");

        perror("open_port: Unable to open /dev/ttyACM0 - ");
      }
      else{
        fcntl(fd, F_SETFL, 0);
        printf("Port ouvert\n");
      }

      return (fd);
    }

    int main(){
      //Open the serial link to the Arduino
      fd = open_port();

      //Variables utilisées dans le reste du programme
      char commande [11];
      char capteur [24];
      int cpt=0;
      int n;
      char buf;
      int newdata=0;
      int descrcom;
      int descrcap;

      /*setting the baud rate*/
      struct termios options;

      tcgetattr(fd, &options);

      cfsetispeed(&options, B115200);
      cfsetospeed(&options, B115200);

      options.c_cflag |= (CLOCAL | CREAD);

      tcsetattr(fd, TCSANOW, &options);
      /*****************************/

      //Activer le handler qui fermera les fichiers en cas d'interruption
      struct sigaction act;
	  act.sa_handler = intHandler;
	  sigaction(SIGINT, &act, NULL);
	  sigaction(SIGQUIT, &act, NULL);

      //Ouvrir le fichier d'échange de données entre le serveur et le programme
      fcom=fopen("commande.txt","w+");
      descrcom = fileno(fcom);
      fputs("X+000Y+000\n", 11, (FILE*)fcom);

      while(1){
      	
		flock(descrcom, LOCK_EX);
      	fgets(commande, 11, (FILE*)fcom);
      	flock(descrcom, LOCK_UN);
	
		//n = write(fd, "X+000Y-505", 10);
		n = write(fd, commande, 10);
	        if (n < 0)
	          printf("Ecriture échouée\n");		
		
		cpt=0;
		newdata=0;
		while(newdata==0){
	        	while((read(fd,&buf,sizeof(buf))>0)&&(cpt++<24)){
			       	printf("%c",buf); //in the future, do something with the data, send it to the server
					capteur[cpt]=buf;
					newdata=1;
			}
		}

		fcap=fopen("capteurs.txt","w+");
      	int descrcap = fileno(fcap);
      	flock(descrcap, LOCK_EX);
      	fputs(capteur, 24, (FILE*)fcap);
      	flock(descrcap, LOCK_UN);
      	fclose(fcap);

		/*flock(descrcom, LOCK_EX);
      	fgets(commande, 11, (FILE*)fcom);
      	flock(descrcom, LOCK_UN);
	
		//n = write(fd, "X+000Y-505", 10);
		n = write(fd, commande, 10);
		if(n<0) printf("Ecriture échouée\n");

		cpt=0;	
		newdata=0;
		while(newdata==0){
			while((read(fd,&buf,sizeof(buf))>0)&&(cpt++<24)){
			       	printf("%c",buf);
				newdata=1;
			}
		}

		fcap=fopen("capteurs.txt","w+");
      	int descrcap = fileno(fcap);
      	flock(descrcap, LOCK_EX);
      	fputs(capteur, 24, (FILE*)fcap);
      	flock(descrcap, LOCK_UN);
      	fclose(fcap);*/
      }

      fclose(fcap);
      close(fd);

  }

