/*envoie des données via serveur ou rj11, 1=serveur, 0=rj11*/
#define serveur 1

/* LED variables & libraries */
#define led_r 8                                           // Red   value for RGB LED on interfaces board
#define led_g 9                                           // Green value for RGB LED on interfaces board
#define led_b 10                                          // Blue  value for RGB LED on interfaces board

/* DAC variables & libraries */
#include <Wire.h>
#include "Adafruit_MCP4725.h"
Adafruit_MCP4725 dac_motorD ;                             // Defines right ...
Adafruit_MCP4725 dac_motorG ;                             // and left Digital to Analog Converters

/* Joystick variables & libraries */
#define JOYSTICK_X A9                                     // Joystick's horizontal value (abscissa axis) : allows to turn right or left
#define JOYSTICK_Y A6                                     // Joystick's vertical value (ordinate axis) : allows to go forward or backward
#define JOYSTICK_THRESHOLD 20                             // Threshold which determines the limit for the 0 position
#define MAX_SPEED 2146                                    // Max value to send to DAC to get max voltage for speed controllers => 2.725/5.2*4095 = 2146
                                                          // with 2.725 the voltage value to get the max speed from speed controllers according to tests | 5.2 the USB voltage | 4095 the max value for DAC
int calX, calY, vitesse, direction ;
float coefG, coefD ;                                      // Factor for left and right motors (depends of JOYSTICK_X)
#define MOTEUR_STOP 0                                     // Defines different states when robot doesn't move ...
#define MOTEUR_AVANCE 1                                   // is moving forward ...
#define MOTEUR_RECULE 2                                   // or moving backward
#define MOTEUR_GAUCHE 3
#define MOTEUR_DROITE 4


/* Motors variables & libraries */
#define PINAVMOTG 46                                      // Activate the relay which allows left motors to move forward the robot
#define PINARMOTG 47                                      // Activate the relay which allows left motors to move backward the robot

#define PINAVMOTD 48                                      // Activate the relay which allows right motors to move forward the robot
#define PINARMOTD 49                                      // Activate the relay which allows right motors to move backward the robot

int vitesse_gauche = 0 ;
int vitesse_droit = 0 ;
// rawX : valeur brute en X du joystick centrée sur calX
// rawY : valeur brute en Y du joystick centrée sur calY
int rawX, rawY;

/*Sensor variables*/
int capteurahg = A10;
int capteurahd = A11;
int capteurabg = A12;
int capteurabd = A13;
int capteurarg = A14;
int capteurard = A15;
int mesures=0;
int capteurs=0;

int ahg,ahd,abg,abd,arg,ard,ahgt,ahdt,abgt,abdt,argt,ardt;

/*Communication série*/
char data [11];
boolean newData = false;


void setup()
{
  //gestion des variateurs
  Serial.begin(115200) ;
  //Serial.print("Initialisation") ;

  //DAC_INIT_() ;
  //Serial.print(".") ;
  dac_motorD.begin(0x62);
  //Serial.print(".") ;// MCP4725's A0 = MCP4725's GND
  dac_motorG.begin(0x63); 
  //Serial.print(".") ;// MCP4725's A0 = MCP4725's Vin
  dac_motorD.setVoltage(131, true) ;   
  //Serial.print(".") ;// voltage is 131/4095 * 5.15 = 0.165 V, required to pass speed controllers' checking
  dac_motorG.setVoltage(131, true) ;                                // flag 'true' allows Arduino writing this value in the EEPROM of the MCP4725 : this value will be the default value sent by the MCP4725 on restarts
  //Serial.print(".") ;
 
  //joystick_INIT_() ;
  if(serveur==0){
    calX = analogRead(JOYSTICK_X);
    calY = analogRead(JOYSTICK_Y);
    //Serial.print(".") ;
  }
  else if(serveur==1){
    calX=1;
    calY=1;
  }
 
  //pinMode(PINAL, OUTPUT) ; //init mot
  pinMode(PINAVMOTD, OUTPUT) ;
  pinMode(PINARMOTD, OUTPUT) ;
  pinMode(PINAVMOTG, OUTPUT) ;
  pinMode(PINARMOTG, OUTPUT) ;

  digitalWrite(PINAVMOTD, LOW) ;
  digitalWrite(PINARMOTD, LOW) ;
  digitalWrite(PINAVMOTG, LOW) ;
  digitalWrite(PINARMOTG, LOW) ;

  //pinMode des capteurs
  pinMode(capteurahg , INPUT) ;
  pinMode(capteurabg , INPUT) ;
  pinMode(capteurahd , INPUT) ;
  pinMode(capteurabd , INPUT) ;
  pinMode(capteurarg , INPUT) ;
  pinMode(capteurard , INPUT) ;
  
}


void loop()
{
  joystick_getData(calX, calY, &coefG, &coefD, &vitesse, &direction);

  // Affichage de la vitesse du moteur gauche
  //Serial.print("Moteur Gauche : ");
  //Serial.println((int)(vitesse * coefG));
  vitesse_gauche = vitesse * coefG ;
  
  // Affichage de la vitesse du moteur droit
  //Serial.print("Moteur Droit : ");
  //  Serial.println((int)(vitesse * coefD));
  vitesse_droit = vitesse * coefD ;

  if(vitesse_gauche>2146) vitesse_gauche=2146;
  if(vitesse_droit>2146) vitesse_droit=2146;

  /*Serial.println("Vitesse:");
  Serial.println(vitesse);*/
 
  if(((ahg>400 || ahd>400 || abg>400 || abd>400)&&direction==MOTEUR_AVANCE)&&capteurs==1){
        
    recule_gauche(500);
    recule_droit(500);
    
    while(ahg>450 || ahd>450 || abg>450 || abd>450){
      ahg=ahd=abg=abd=0;
      for(int j=0;j<10;j++){
        ahg+=analogRead(capteurahg);
        ahd+=analogRead(capteurahd);
        abg+=analogRead(capteurabg);
        abd+=analogRead(capteurabd);
      }
      ahg=ahg/10;
      ahd=ahd/10;
      abg=abg/10;
      abd=abd/10;
    }
  }
  else if((((ard>450 || arg>450)&&direction==MOTEUR_RECULE))&&capteurs==1){
    avance_gauche(500);
    avance_droit(500);
    
    while(arg>450 || ard>450){
      arg=ard=0;
      for(int j=0;j<10;j++){
        arg+=analogRead(capteurarg);
        ard+=analogRead(capteurard);
      }
      arg=arg/10;
      ard=ard/10;
    }
  }
  else if(direction == MOTEUR_AVANCE) // Vers l'avant
    {
      //Serial.println("AVANT");
      if(vitesse_gauche>70) avance_gauche(vitesse_gauche) ;
      else digitalWrite(PINAVMOTG,LOW);
      if(vitesse_droit>70) avance_droit(vitesse_droit) ;
      else digitalWrite(PINAVMOTD,LOW);
    }
    else if(direction == MOTEUR_RECULE) // Vers l'arriére   //!si avance => arrière, passer par arrêt d'abord. Vérif: seuil de vitesse
    {
      //Serial.println("ARRIERE");
      if(vitesse_gauche>70) recule_gauche(vitesse_gauche) ;
      else digitalWrite(PINARMOTG,LOW);
      if(vitesse_droit>70) recule_droit(vitesse_droit) ;
      else digitalWrite(PINARMOTD,LOW);
    }
    else if(direction == MOTEUR_GAUCHE){
      //Serial.println("GAUCHE");
      if(vitesse_gauche>70) avance_gauche(vitesse_gauche);
      else digitalWrite(PINAVMOTG,LOW);
      if(vitesse_droit>70) recule_droit(vitesse_droit);
      else digitalWrite(PINARMOTD,LOW);     
    }
    else if(direction == MOTEUR_DROITE){
      //Serial.println("DROITE");
      digitalWrite(led_r, HIGH) ;
      digitalWrite(led_g, LOW) ;
      digitalWrite(led_b, HIGH) ;
      if(vitesse_droit>70) avance_droit(vitesse_droit);
      else digitalWrite(PINAVMOTD,LOW);
      if(vitesse_gauche>70) recule_gauche(vitesse_gauche);
      else digitalWrite(PINARMOTG,LOW);
    }
  else
  {
    //Serial.println("ARRET") ;                           // Aucun mouvement
    digitalWrite(led_b, HIGH) ;
    digitalWrite(led_r, LOW) ;
    digitalWrite(led_g, LOW) ;
   
    digitalWrite(PINAVMOTD, LOW) ;
    digitalWrite(PINARMOTD, LOW) ;
    digitalWrite(PINAVMOTG, LOW) ;
    digitalWrite(PINARMOTG, LOW) ;

    dac_motorD.setVoltage(131, true) ;   
  //Serial.print(".") ;// voltage is 131/4095 * 5.15 = 0.165 V, required to pass speed controllers' checking
   dac_motorG.setVoltage(131, true) ;   
  }
 
  //delay(20);
}

void joystick_getData(int calX, int calY, float *coefG, float *coefD, int *vitesse, int *direction)
{
  newData=false;
  int i=0;

  if(serveur==0){
    // Mesure des valeurs brute en X et Y
    rawX = -(analogRead(JOYSTICK_X) - calX); 
    Serial.print("valeur X : ") ; Serial.println(rawX) ;
    rawY = -(analogRead(JOYSTICK_Y) - calY);
    Serial.print("valeur Y : ") ; Serial.println(rawY) ;
  }
  else if(serveur==1){
    //Serial.println("Lecture...");
      while(newData==false){
        if(mesures<10){
          ahg=ahd=abg=abd=arg=ard=0;
          capteurs=0;
          mesures++;
          ahgt+=analogRead(capteurahg);
          ahdt+=analogRead(capteurahd);
          abgt+=analogRead(capteurabg);
          abdt+=analogRead(capteurabd);
          argt+=analogRead(capteurarg);
          ardt+=analogRead(capteurard);
        }
        else{
          mesures=0;
          capteurs=1;
          ahg=ahgt/10;
          ahd=ahdt/10;
          abg=abgt/10;
          abd=abdt/10;
          arg=argt/10;
          ard=ardt/10;
          Serial.print("1");Serial.print(ahg);Serial.print("2");Serial.print(ahd);Serial.print("3");Serial.print(abg);Serial.print("4");Serial.print(abd);Serial.print("5");Serial.print(arg);Serial.print("6");Serial.print(ard);
          ahgt=ahdt=abgt=abdt=argt=ardt=0;
          newData=true;
        }
        i=0;
        while(Serial.available()>0 && i<11){
           data[i] = Serial.read();
           i++;
        }
           if(data[0]=='X'&&data[5]=='Y'){
             newData=true;
             rawX=(((int)data[2]-48)*100)+(((int)data[3]-48)*10)+(int)data[4]-48;
             rawY=(((int)data[7]-48)*100)+(((int)data[8]-48)*10)+(int)data[9]-48;
             
             if(data[1]==45) rawX=-rawX;
             if(data[6]==45) rawY=-rawY;
             
             /*Serial.println("rawX:");
             Serial.println(rawX);
             Serial.println("rawY:");
             Serial.println(rawY);*/
             
           }
           else i=0;
           delay(10);
      }
      //else Serial.print("Erreur de réception ...\n");
    }
 
  // Si rawX < -THRESHOLD alors coefG = -rawX / calX sinon coefG = 1
  *coefD = (rawX < -JOYSTICK_THRESHOLD) ? (1023/2+rawX)/((float)calX) : 1;
  
  // Si rawX > THRESHOLD alors coefD = rawX / calX sinon coefD = 1
  *coefG = (rawX > JOYSTICK_THRESHOLD) ? (1023/2-rawX)/((float)calX) : 1;
 
  // Si -THRESHOLD < rawY < THRESHOLD
  if(rawY > -JOYSTICK_THRESHOLD && rawY < JOYSTICK_THRESHOLD)
  {
    if(rawX < -250){
      *direction = MOTEUR_DROITE;
      *vitesse = -map(rawX, 0, 1023 - calX, 0, MAX_SPEED);
      *coefD=0.7;
      *coefG=0.7;
    }

    else if(rawX > 250){
      *direction = MOTEUR_GAUCHE;
      *vitesse = map(rawX, 0, 1023 - calX, 0, MAX_SPEED);
      *coefG=0.7;
      *coefD=0.7;
    }

    else{
      // Les moteurs sont marqués comme arrétés, et vitesse = 0
      *direction = MOTEUR_STOP;
      *vitesse = 0;
    }
  } 
  // Si rawY >= 0
  else if(rawY >= 0)
  {
    // Les moteurs sont marqués en mode "avance"
    *direction = MOTEUR_AVANCE;
  
    // La vitesse est égale à map(rawY) depuis 0 ~ (1023 - calY) vers 0 ~ MAX_SPEED
    *vitesse = map(rawY, 0, 1023 - calY, 0, MAX_SPEED);
  }
  // Si rawY < 0
  else if(rawY <= 0)
  {
    // Les moteurs sont marqués en mode "recule"
    *direction = MOTEUR_RECULE;
    // La vitesse est égale à map(rawY) depuis 0 ~ calY vers 0 ~ MAX_SPEED
    *vitesse = map(-rawY, 0, calY, 0, MAX_SPEED);
  }

  /*Serial.print("CoefG: ");
  Serial.println((int)*coefG);

  Serial.print("CoefD: ");
  Serial.println((int)*coefD);
 
  Serial.print("CalX: ");
  Serial.println(calX);*/
}

void recule_gauche(int vit)
{
  digitalWrite(PINAVMOTG, LOW) ;
  digitalWrite(PINARMOTG, HIGH) ;
  dac_motorG.setVoltage(vit, false);
}

void recule_droit(int vit)
{
  digitalWrite(PINAVMOTD, LOW) ;
  digitalWrite(PINARMOTD, HIGH) ;
  dac_motorD.setVoltage(vit, false);
}

void avance_gauche(int vit)
{
  digitalWrite(PINARMOTG, LOW) ;
  digitalWrite(PINAVMOTG, HIGH) ;
  dac_motorG.setVoltage(vit, false);
}

void avance_droit(int vit)
{
  digitalWrite(PINARMOTD, LOW) ;
  digitalWrite(PINAVMOTD, HIGH) ;
  dac_motorD.setVoltage(vit, false);
}